/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.util.AbstractTreePrinter;
import org.jsweet.transpiler.util.Util;

public class TypeChecker {
    public static boolean jdkAllowed = true;
    static final Set<String> AUTHORIZED_ACCESSED_TYPES = new HashSet<String>();
    static final Set<String> AUTHORIZED_DECLARED_TYPES = new HashSet<String>();
    public static final Set<String> NUMBER_TYPES = new HashSet<String>();
    public static final Set<String> NUMBER_TYPE_NAMES = new HashSet<String>();
    public static final Set<String> AUTHORIZED_OBJECT_METHODS = new HashSet<String>();
    public static final Set<String> AUTHORIZED_STRING_METHODS = new HashSet<String>();
    public static final Set<String> FORBIDDEN_JDK_FUNCTIONAL_METHODS = new HashSet<String>();
    private final AbstractTreePrinter translator;
    private final JSweetContext context;

    public TypeChecker(AbstractTreePrinter translator) {
        this.translator = translator;
        this.context = translator.getContext();
    }

    public boolean checkApply(MethodInvocationTree invocation, ExecutableElement methSym) {
        TypeElement parentType;
        if (!JSweetConfig.isJDKReplacementMode() && !jdkAllowed && (parentType = this.util().getParentElement(methSym, TypeElement.class)) != null && parentType.getQualifiedName().toString().startsWith("java.")) {
            if (invocation.getMethodSelect() instanceof MemberSelectTree && "super".equals(((MemberSelectTree)invocation.getMethodSelect()).getExpression().toString())) {
                this.translator.report((Tree)invocation, JSweetProblem.JDK_METHOD, methSym);
                return false;
            }
            if (this.translator.getContext().strictMode || AUTHORIZED_OBJECT_METHODS.contains(methSym.getSimpleName().toString())) {
                return true;
            }
            if (parentType.getQualifiedName().toString().equals(String.class.getName()) && AUTHORIZED_STRING_METHODS.contains(methSym.toString())) {
                return true;
            }
            this.translator.report((Tree)invocation, JSweetProblem.JDK_METHOD, methSym);
            return false;
        }
        return true;
    }

    public boolean checkType(Tree declaringElement, Name declaringElementName, Tree typeExpression, CompilationUnitTree compilationUnit) {
        if (!JSweetConfig.isJDKReplacementMode()) {
            if (typeExpression instanceof ArrayTypeTree) {
                return this.checkType(declaringElement, declaringElementName, ((ArrayTypeTree)typeExpression).getType(), compilationUnit);
            }
            Object type = Util.getType(typeExpression);
            if (type != null) {
                String typeName = type.toString();
                if (!(jdkAllowed || this.translator.getContext().strictMode || !typeName.startsWith("java.") || AUTHORIZED_DECLARED_TYPES.contains(typeName) || NUMBER_TYPES.contains(typeName) || typeName.startsWith("java.util.function"))) {
                    this.translator.report(declaringElement, declaringElementName, JSweetProblem.JDK_TYPE, typeName);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean checkSelect(MemberSelectTree select, CompilationUnitTree compilationUnit) {
        String type;
        Object selectedType;
        if (!JSweetConfig.isJDKReplacementMode() && (selectedType = Util.getType(select.getExpression())) instanceof DeclaredType && (type = this.context.types.asElement((TypeMirror)selectedType).toString()).startsWith("java.") && !jdkAllowed && !AUTHORIZED_ACCESSED_TYPES.contains(type) && !type.startsWith("java.util.function")) {
            this.translator.report((Tree)select, JSweetProblem.JDK_TYPE, type);
            return false;
        }
        return true;
    }

    private boolean checkUnionTypeAssignment(Tree parent, TypeMirror assigned, MethodInvocationTree union, CompilationUnitTree compilationUnit) {
        TypeElement firstArgTypeElement = (TypeElement)Util.getTypeElement(union.getArguments().get(0));
        if (firstArgTypeElement != null && this.util().getQualifiedName(firstArgTypeElement).startsWith("jsweet.util.union.Union")) {
            VariableElement unionVariableElement = (VariableElement)Util.getElement(union.getArguments().get(0));
            List<? extends TypeMirror> typeArguments = ((DeclaredType)unionVariableElement.asType()).getTypeArguments();
            if (!this.util().containsAssignableType(typeArguments, assigned)) {
                this.translator.report(parent, JSweetProblem.UNION_TYPE_MISMATCH, new Object[0]);
                return false;
            }
        } else {
            String typeName = this.util().getQualifiedName(firstArgTypeElement);
            if (typeName != null && "def.js.Function".equals(typeName) || "jsweet.lang.Function".equals(typeName)) {
                return true;
            }
            if (assigned instanceof DeclaredType && !this.util().containsAssignableType(((DeclaredType)assigned).getTypeArguments(), (TypeMirror)Util.getType(union.getArguments().get(0)))) {
                this.translator.report(parent, JSweetProblem.UNION_TYPE_MISMATCH, new Object[0]);
                return false;
            }
        }
        return true;
    }

    public boolean checkUnionTypeAssignment(Tree parent, CompilationUnitTree compilationUnit, MethodInvocationTree union) {
        if (parent instanceof VariableTree) {
            VariableTree decl = (VariableTree)parent;
            if (decl.getInitializer() == union) {
                Object varType = Util.getType(decl);
                return this.checkUnionTypeAssignment(parent, (TypeMirror)varType, union, compilationUnit);
            }
        } else if (parent instanceof AssignmentTree) {
            AssignmentTree assign = (AssignmentTree)parent;
            if (assign.getExpression() == union) {
                Object varType = Util.getType(assign.getVariable());
                return this.checkUnionTypeAssignment(parent, (TypeMirror)varType, union, compilationUnit);
            }
        } else if (parent instanceof MethodInvocationTree) {
            MethodInvocationTree invocation = (MethodInvocationTree)parent;
            for (Tree tree : invocation.getArguments()) {
                if (tree != union) continue;
                Object varType = Util.getType(tree);
                return this.checkUnionTypeAssignment(parent, (TypeMirror)varType, union, compilationUnit);
            }
        }
        return true;
    }

    protected Util util() {
        return this.context.util;
    }

    static {
        AUTHORIZED_DECLARED_TYPES.add(String.class.getName());
        AUTHORIZED_DECLARED_TYPES.add(Object.class.getName());
        AUTHORIZED_DECLARED_TYPES.add(Class.class.getName());
        AUTHORIZED_DECLARED_TYPES.add(Boolean.class.getName());
        AUTHORIZED_DECLARED_TYPES.add(Void.class.getName());
        NUMBER_TYPES.add(Integer.class.getName());
        NUMBER_TYPES.add(Double.class.getName());
        NUMBER_TYPES.add(Number.class.getName());
        NUMBER_TYPES.add(Float.class.getName());
        NUMBER_TYPES.add(Byte.class.getName());
        NUMBER_TYPES.add(Short.class.getName());
        NUMBER_TYPE_NAMES.add(Integer.class.getSimpleName());
        NUMBER_TYPE_NAMES.add(Double.class.getSimpleName());
        NUMBER_TYPE_NAMES.add(Number.class.getSimpleName());
        NUMBER_TYPE_NAMES.add(Float.class.getSimpleName());
        NUMBER_TYPE_NAMES.add(Byte.class.getSimpleName());
        NUMBER_TYPE_NAMES.add(Short.class.getSimpleName());
        AUTHORIZED_DECLARED_TYPES.add(Runnable.class.getName());
        AUTHORIZED_OBJECT_METHODS.add("toString");
        AUTHORIZED_STRING_METHODS.add("charAt(int)");
        AUTHORIZED_STRING_METHODS.add("concat(java.lang.String)");
        AUTHORIZED_STRING_METHODS.add("indexOf(java.lang.String)");
        AUTHORIZED_STRING_METHODS.add("lastIndexOf(java.lang.String)");
        AUTHORIZED_STRING_METHODS.add("lastIndexOf(java.lang.String,int)");
        AUTHORIZED_STRING_METHODS.add("substring(int)");
        AUTHORIZED_STRING_METHODS.add("substring(int,int)");
        AUTHORIZED_STRING_METHODS.add("replace(java.lang.CharSequence,java.lang.CharSequence)");
        AUTHORIZED_STRING_METHODS.add("split(java.lang.String)");
        AUTHORIZED_STRING_METHODS.add("trim()");
        AUTHORIZED_STRING_METHODS.add("toLowerCase()");
        AUTHORIZED_STRING_METHODS.add("toUpperCase()");
        AUTHORIZED_STRING_METHODS.add("length()");
        FORBIDDEN_JDK_FUNCTIONAL_METHODS.add("and");
        FORBIDDEN_JDK_FUNCTIONAL_METHODS.add("negate");
        FORBIDDEN_JDK_FUNCTIONAL_METHODS.add("or");
        FORBIDDEN_JDK_FUNCTIONAL_METHODS.add("andThen");
    }
}

