/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.apache.log4j.Logger;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.util.DirectedGraph;
import org.jsweet.transpiler.util.ReferenceGrabber;
import org.jsweet.transpiler.util.Util;

public class StaticInitilializerAnalyzer
extends TreePathScanner<Void, Trees> {
    private JSweetContext context;
    private CompilationUnitTree currentCompilationUnit;
    private int pass = 1;
    private static final Logger logger = Logger.getLogger(StaticInitilializerAnalyzer.class);
    public Map<PackageTree, DirectedGraph<CompilationUnitTree>> staticInitializersDependencies = new HashMap<PackageTree, DirectedGraph<CompilationUnitTree>>();
    public DirectedGraph<CompilationUnitTree> globalStaticInitializersDependencies = new DirectedGraph();
    public Map<TypeElement, CompilationUnitTree> typesToCompilationUnits = new HashMap<TypeElement, CompilationUnitTree>();
    Set<TypeMirror> currentTopLevelImportedTypes = new HashSet<TypeMirror>();

    public StaticInitilializerAnalyzer(JSweetContext context) {
        this.context = context;
        this.context.referenceAnalyzer = this;
    }

    private DirectedGraph<CompilationUnitTree> getGraph() {
        return this.globalStaticInitializersDependencies;
    }

    public boolean isDependent(CompilationUnitTree cuSource, TypeElement target) {
        CompilationUnitTree cuTarget = this.typesToCompilationUnits.get(target);
        if (cuSource != null && cuTarget != null) {
            return this.globalStaticInitializersDependencies.hasEdge(cuTarget, cuSource);
        }
        return false;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree compilationUnit, Trees trees) {
        this.currentCompilationUnit = compilationUnit;
        if (this.pass == 1) {
            this.getGraph().add(compilationUnit);
        } else {
            if (this.context.util.getPackageFullNameForCompilationUnit(compilationUnit).startsWith("def.")) {
                return null;
            }
            this.currentTopLevelImportedTypes.clear();
            for (ImportTree importTree : compilationUnit.getImports()) {
                TypeMirror importedType = this.getImportedType(compilationUnit, importTree);
                if (importedType == null) continue;
                this.currentTopLevelImportedTypes.add(importedType);
            }
        }
        super.visitCompilationUnit(compilationUnit, trees);
        this.currentCompilationUnit = null;
        return null;
    }

    private TypeMirror getImportedType(CompilationUnitTree compilationUnit, ImportTree importTree) {
        Tree importedIdentifier = importTree.getQualifiedIdentifier();
        Object importedType = Util.getType(importedIdentifier);
        return importedType;
    }

    @Override
    public Void visitClass(ClassTree classTree, Trees trees) {
        if (this.pass == 1) {
            this.typesToCompilationUnits.put((TypeElement)Util.getElement(classTree), this.currentCompilationUnit);
        } else {
            CompilationUnitTree target;
            if (classTree.getExtendsClause() != null && (target = this.typesToCompilationUnits.get(Util.getTypeElement(classTree.getExtendsClause()))) != null && this.getGraph().contains(target)) {
                logger.debug((Object)("adding inheritance dependency: " + this.currentCompilationUnit.getSourceFile() + " -> " + target.getSourceFile()));
                this.getGraph().addEdge(target, this.currentCompilationUnit);
            }
            for (Tree tree : classTree.getMembers()) {
                BlockTree initializer;
                if (tree instanceof VariableTree) {
                    VariableTree field = (VariableTree)tree;
                    if (!field.getModifiers().getFlags().contains((Object)Modifier.STATIC) || field.getInitializer() == null || this.context.hasAnnotationType((Element)Util.getElement(field), "jsweet.lang.StringType", "jsweet.lang.Erased")) continue;
                    this.acceptReferences(field.getInitializer());
                    continue;
                }
                if (!(tree instanceof BlockTree) || !(initializer = (BlockTree)tree).isStatic()) continue;
                this.acceptReferences(initializer);
            }
        }
        return (Void)super.visitClass(classTree, trees);
    }

    private void acceptReferences(Tree tree) {
        ReferenceGrabber refGrabber = new ReferenceGrabber();
        refGrabber.scan(tree, this.context.trees);
        for (TypeMirror referencedType : refGrabber.referencedTypes) {
            CompilationUnitTree target;
            TypeElement referencedTypeElement = (TypeElement)this.context.types.asElement(referencedType);
            PackageElement referencedPackageElement = this.context.util.getParentElement(referencedTypeElement, PackageElement.class);
            PackageElement currentPackageElement = (PackageElement)Util.getElement(this.currentCompilationUnit.getPackage());
            if (this.context.useModules && !Objects.equals(currentPackageElement, referencedPackageElement) || (target = this.typesToCompilationUnits.get(referencedTypeElement)) == null || this.currentCompilationUnit.equals(target) || !this.getGraph().contains(target)) continue;
            logger.debug((Object)("adding static initializer dependency: " + this.currentCompilationUnit.getSourceFile() + " -> " + target.getSourceFile()));
            this.getGraph().addEdge(target, this.currentCompilationUnit);
        }
    }

    public void process(Collection<CompilationUnitTree> compilationUnits) {
        this.scan(compilationUnits, this.context.trees);
        ++this.pass;
        this.scan(compilationUnits, this.context.trees);
    }
}

