/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import java.io.File;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.apache.log4j.Logger;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.JSweetTranspiler;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.TranspilationHandler;

public class JSweetDiagnosticHandler
implements DiagnosticListener<JavaFileObject> {
    protected TranspilationHandler transpilationHandler;
    protected JSweetContext context;
    private static final Logger logger = Logger.getLogger(JSweetTranspiler.class);

    public JSweetDiagnosticHandler(TranspilationHandler transpilationHandler, JSweetContext context) {
        this.context = context;
        this.transpilationHandler = transpilationHandler;
    }

    protected void reportJavaError(Diagnostic<? extends JavaFileObject> diagnostic, Locale locale) {
        this.transpilationHandler.report(JSweetProblem.INTERNAL_JAVA_ERROR, new SourcePosition(new File(diagnostic.getSource() == null ? "." : diagnostic.getSource().getName()), null, (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber()), diagnostic.getMessage(locale));
    }

    private boolean ignoreError(Diagnostic<? extends JavaFileObject> diagnostic) {
        if (this.context.options.isIgnoreJavaErrors()) {
            return true;
        }
        return this.context.options.isIgnoreJavaFileNameError() && "compiler.err.class.public.should.be.in.file".equals(diagnostic.getCode());
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        Locale locale = this.context.locale;
        if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
            if (!this.ignoreError(diagnostic)) {
                this.reportJavaError(diagnostic, locale);
            } else {
                return;
            }
        }
        switch (diagnostic.getKind()) {
            case ERROR: {
                logger.error(diagnostic);
                break;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                logger.debug(diagnostic);
                break;
            }
            default: {
                logger.trace(diagnostic);
            }
        }
    }
}

