/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.Trees;
import java.io.File;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.ConstAnalyzer;
import org.jsweet.transpiler.JSweetOptions;
import org.jsweet.transpiler.Java2TypeScriptTranslator;
import org.jsweet.transpiler.OverloadScanner;
import org.jsweet.transpiler.SourceFile;
import org.jsweet.transpiler.StaticInitilializerAnalyzer;
import org.jsweet.transpiler.extension.AnnotationManager;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.util.DirectedGraph;
import org.jsweet.transpiler.util.Util;

public class JSweetContext {
    protected static Logger logger = Logger.getLogger(Java2TypeScriptTranslator.class);
    public ConstAnalyzer constAnalyzer = null;
    private Map<String, TypeMirror> jdkSubclasses = new HashMap<String, TypeMirror>();
    public StaticInitilializerAnalyzer referenceAnalyzer;
    private List<AnnotationManager> annotationManagers = new ArrayList<AnnotationManager>();
    private Map<String, String> typesMapping = new HashMap<String, String>();
    private List<BiFunction<ExtendedElement, String, Object>> functionalTypeTreeMappings = new ArrayList<BiFunction<ExtendedElement, String, Object>>();
    private List<Function<TypeMirror, String>> functionalTypeMappings = new ArrayList<Function<TypeMirror, String>>();
    protected Map<String, String> langTypesMapping = new HashMap<String, String>();
    protected Set<String> langTypesSimpleNames = new HashSet<String>();
    protected Set<String> baseThrowables = new HashSet<String>();
    private Map<String, GlobalMethodInfos> globalMethods = new HashMap<String, GlobalMethodInfos>();
    private Map<String, ClassTree> decoratorAnnotations = new HashMap<String, ClassTree>();
    private Pattern annotationWithParameterPattern = Pattern.compile("@([^(]*)\\((.*)\\)");
    private Map<String, Collection<AnnotationFilterDescriptor>> annotationFilters = new HashMap<String, Collection<AnnotationFilterDescriptor>>();
    public static ThreadLocal<JSweetContext> current = new ThreadLocal();
    public static ThreadLocal<CompilationUnitTree> currentCompilationUnit = new ThreadLocal();
    private boolean usingJavaRuntime = false;
    public final Locale locale = Locale.getDefault();
    public final JSweetOptions options;
    private Map<TypeElement, Map<String, OverloadScanner.Overload>> overloads = new HashMap<TypeElement, Map<String, OverloadScanner.Overload>>();
    private Map<TypeElement, Map<String, OverloadScanner.Overload>> staticOverloads = new HashMap<TypeElement, Map<String, OverloadScanner.Overload>>();
    public Set<TypeElement> classesWithWrongConstructorOverload = new HashSet<TypeElement>();
    public Types types;
    public Trees trees;
    public Elements elements;
    public Util util = new Util(this);
    public boolean useModules = false;
    public boolean useRequireForModules = true;
    public SourceFile[] sourceFiles;
    public Set<String> excludedSourcePaths;
    public List<CompilationUnitTree> compilationUnits;
    private List<String> usedModules = new ArrayList<String>();
    public boolean bundleMode = false;
    public boolean moduleBundleMode = false;
    public Set<VariableElement> lazyInitializedStatics = new HashSet<VariableElement>();
    private Map<TypeElement, Integer> staticInitializerCounts = new HashMap<TypeElement, Integer>();
    private Map<String, Set<String>> importedNamesInModules = new HashMap<String, Set<String>>();
    private Map<String, Map<Element, String>> importedElementsInModules = new HashMap<String, Map<Element, String>>();
    private Map<String, List<Element>> exportedElements = new HashMap<String, List<Element>>();
    private Map<Element, String> exportedNames = new HashMap<Element, String>();
    public List<File> entryFiles = new ArrayList<File>();
    public DirectedGraph<PackageElement> packageDependencies = new DirectedGraph();
    public Set<String> topLevelPackageNames = new HashSet<String>();
    public HashSet<PackageElement> rootPackages = new HashSet();
    public boolean reportedMultipleRootPackages = false;
    public Set<String> globalImports = new HashSet<String>();
    public Set<String> importedTopPackages = new HashSet<String>();
    public boolean strictMode = false;
    public boolean deprecatedApply = false;
    private List<Map.Entry<String, String>> footerStatements = new LinkedList<Map.Entry<String, String>>();
    private boolean forceTopImports = false;
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private Map<String, String> globalsMapping = new HashMap<String, String>();
    private final Map<TypeElement, Set<DefaultMethodEntry>> defaultMethods = new HashMap<TypeElement, Set<DefaultMethodEntry>>();
    private final Map<MethodTree, CompilationUnitTree> defaultMethodsCompilationUnits = new HashMap<MethodTree, CompilationUnitTree>();
    private Map<VariableElement, String> fieldNameMapping = new HashMap<VariableElement, String>();
    private Map<ExecutableElement, String> methodNameMapping = new HashMap<ExecutableElement, String>();
    private Map<TypeElement, String> classNameMapping = new HashMap<TypeElement, String>();
    public boolean ignoreWildcardBounds = true;
    private Map<WildcardTree, String> wildcardNames = new HashMap<WildcardTree, String>();
    private Map<ExecutableElement, List<WildcardTree>> wildcards = new HashMap<ExecutableElement, List<WildcardTree>>();
    private static Pattern libPackagePattern = Pattern.compile("def\\.[^.]*");
    private Map<String, Set<Element>> extraAnnotations;
    public Map<Element, String> docComments = new HashMap<Element, String>();
    private final Map<Tree, CompilationUnitTree> compilationUnitsMapping = new HashMap<Tree, CompilationUnitTree>();
    private Set<MethodInvocationTree> awaitInvocations;

    public void addJdkSubclass(String subclassName, TypeMirror extendedJdkClass) {
        this.jdkSubclasses.put(subclassName, extendedJdkClass);
    }

    public Map<String, TypeMirror> getJdkSubclasses() {
        return this.jdkSubclasses;
    }

    public TypeMirror getJdkSuperclass(String subclassName, Set<String> excludedJdkTypes) {
        TypeMirror jdkType = this.jdkSubclasses.get(subclassName);
        if (jdkType == null) {
            return null;
        }
        if (!excludedJdkTypes.contains(jdkType.toString())) {
            return jdkType;
        }
        return null;
    }

    public void registerGlobalMethod(ClassTree owner, MethodTree method, CompilationUnitTree compilationUnit) {
        ExecutableElement methodElement = (ExecutableElement)Util.getElement(method);
        Object name = ((TypeElement)methodElement.getEnclosingElement()).getQualifiedName().toString();
        name = (String)name + "." + method.getName();
        name = ((String)name).replace("Globals.", "");
        this.globalMethods.put((String)name, new GlobalMethodInfos(owner, method, compilationUnit));
    }

    public GlobalMethodInfos lookupGlobalMethod(String fullyQualifiedName) {
        return this.globalMethods.get(fullyQualifiedName);
    }

    public void registerDecoratorAnnotation(ClassTree annotationDeclaration, CompilationUnitTree compilationUnit) {
        TypeElement annotationElement = (TypeElement)Util.getElement(annotationDeclaration);
        this.decoratorAnnotations.put(annotationElement.getQualifiedName().toString(), annotationDeclaration);
    }

    public ClassTree lookupDecoratorAnnotation(String fullyQualifiedName) {
        return this.decoratorAnnotations.get(fullyQualifiedName);
    }

    public final void addTypeMapping(String sourceTypeName, String targetTypeName) {
        this.typesMapping.put(sourceTypeName, targetTypeName);
    }

    public final void addTypeMappings(Map<String, String> nameMappings) {
        this.typesMapping.putAll(nameMappings);
    }

    public final boolean isMappedType(String sourceTypeName) {
        return this.typesMapping.containsKey(sourceTypeName);
    }

    public final String getTypeMappingTarget(String sourceTypeName) {
        return this.typesMapping.get(sourceTypeName);
    }

    public final void addTypeMapping(BiFunction<ExtendedElement, String, Object> mappingFunction) {
        this.functionalTypeTreeMappings.add(mappingFunction);
    }

    public final List<BiFunction<ExtendedElement, String, Object>> getFunctionalTypeMappings() {
        return this.functionalTypeTreeMappings;
    }

    public final void addTypeMapping(Function<TypeMirror, String> mappingFunction) {
        this.functionalTypeMappings.add(mappingFunction);
    }

    public final List<Function<TypeMirror, String>> getFunctionalTypeMirrorMappings() {
        return this.functionalTypeMappings;
    }

    public final void addAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManagers.add(annotationManager);
    }

    public final void removeAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManagers.remove(annotationManager);
    }

    private static boolean testStringAt(StringBuilder sb, int i, String string) {
        if (i < 0) {
            return false;
        }
        if (i + string.length() > sb.length()) {
            return false;
        }
        return sb.subSequence(i, i + string.length()).equals(string);
    }

    private static String toRegexp(String pattern) {
        boolean argsEnv = false;
        StringBuilder sb = new StringBuilder(pattern);
        block6: for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            switch (c) {
                case '(': {
                    argsEnv = true;
                    sb.insert(i++, '\\');
                    continue block6;
                }
                case ')': {
                    argsEnv = false;
                    sb.insert(i++, '\\');
                    continue block6;
                }
                case '.': {
                    if (JSweetContext.testStringAt(sb, i + 1, ".")) {
                        sb.deleteCharAt(i);
                        sb.deleteCharAt(i);
                        sb.insert(i++, ".*");
                        continue block6;
                    }
                    sb.insert(i++, '\\');
                    continue block6;
                }
                case '*': {
                    if (JSweetContext.testStringAt(sb, i + 1, "*")) {
                        sb.deleteCharAt(i);
                        sb.deleteCharAt(i);
                        sb.insert(i++, ".*");
                        continue block6;
                    }
                    sb.deleteCharAt(i);
                    if (argsEnv) {
                        sb.insert(i, "[^,]*");
                        i += 4;
                        continue block6;
                    }
                    sb.insert(i, "[^.]*");
                    i += 4;
                }
            }
        }
        return sb.toString();
    }

    private Collection<AnnotationFilterDescriptor> getAnnotationFilterDescriptors(String annotationType) {
        Collection<AnnotationFilterDescriptor> descrs = this.annotationFilters.get(annotationType);
        if (descrs == null) {
            descrs = new ArrayList<AnnotationFilterDescriptor>();
            this.annotationFilters.put(annotationType, descrs);
        }
        return descrs;
    }

    private boolean hasAnnotationFilters() {
        return !this.annotationFilters.isEmpty();
    }

    public JSweetContext(JSweetOptions options) {
        this.options = options;
        if (options.getConfiguration() != null) {
            for (Map.Entry<String, Object> entry : options.getConfiguration().entrySet()) {
                this.addConfigurationEntry(entry);
            }
        }
        for (Map.Entry<String, Object> entry : this.annotationFilters.entrySet()) {
            logger.info((Object)("annotation filter descriptor: " + entry));
        }
        current.set(this);
    }

    public final void addAnnotation(Class<? extends Annotation> annotationType, String ... filters) {
        this.addAnnotation(annotationType.getName(), filters);
    }

    public final void addAnnotationWithValue(Class<? extends Annotation> annotationType, Object value, String ... filters) {
        this.addAnnotation(annotationType.getName() + "('" + value.toString() + "')", filters);
    }

    public final void addAnnotation(String annotationDescriptor, String ... filters) {
        if (!((String)annotationDescriptor).startsWith("@")) {
            annotationDescriptor = "@" + (String)annotationDescriptor;
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(annotationDescriptor, map);
        for (String filter : filters) {
            String listKind = filter.startsWith("!") ? "exclude" : "include";
            ArrayList<String> list = (ArrayList<String>)map.get(listKind);
            if (list == null) {
                list = new ArrayList<String>();
                map.put(listKind, list);
            }
            list.add(listKind.equals("exclude") ? filter.substring(1).trim() : filter.trim());
        }
        this.addConfigurationEntry(entry);
    }

    private void addConfigurationEntry(Map.Entry<String, Object> untypedEntry) {
        if (untypedEntry.getKey().startsWith("@")) {
            Map.Entry<String, Object> entry = untypedEntry;
            Object annotationType = null;
            Matcher m = this.annotationWithParameterPattern.matcher(entry.getKey());
            String parameter = null;
            if (m.matches()) {
                annotationType = m.group(1).contains(".") ? m.group(1) : "jsweet.lang." + m.group(1);
                parameter = m.group(2);
            } else {
                annotationType = entry.getKey().contains(".") ? entry.getKey().substring(1) : "jsweet.lang." + entry.getKey().substring(1);
            }
            Object include = ((Map)entry.getValue()).get("include");
            Collection<AnnotationFilterDescriptor> filterDescriptors = this.getAnnotationFilterDescriptors((String)annotationType);
            ArrayList<Pattern> inclusionPatterns = null;
            ArrayList<Pattern> exclusionPatterns = null;
            if (include != null) {
                inclusionPatterns = new ArrayList<Pattern>();
                if (include instanceof Collection) {
                    for (Object o : (Collection)include) {
                        try {
                            inclusionPatterns.add(Pattern.compile(JSweetContext.toRegexp(o.toString())));
                        }
                        catch (Exception e) {
                            logger.warn((Object)("invalid pattern '" + o + "' for " + entry.getKey() + ".include"));
                        }
                    }
                } else {
                    try {
                        inclusionPatterns.add(Pattern.compile(JSweetContext.toRegexp(include.toString())));
                    }
                    catch (Exception e) {
                        logger.warn((Object)("invalid pattern '" + include + "' for " + entry.getKey() + ".include"));
                    }
                }
            } else {
                logger.warn((Object)("annotation entry " + entry.getKey() + " does not have a mandatory 'include' entry"));
            }
            Object exclude = ((Map)entry.getValue()).get("exclude");
            if (exclude != null) {
                exclusionPatterns = new ArrayList<Pattern>();
                if (exclude instanceof Collection) {
                    for (Object o : (Collection)exclude) {
                        try {
                            exclusionPatterns.add(Pattern.compile(JSweetContext.toRegexp(o.toString())));
                        }
                        catch (Exception e) {
                            logger.warn((Object)("invalid pattern '" + o + "' for " + entry.getKey() + ".exclude"));
                        }
                    }
                } else {
                    try {
                        exclusionPatterns.add(Pattern.compile(JSweetContext.toRegexp(exclude.toString())));
                    }
                    catch (Exception e) {
                        logger.warn((Object)("invalid pattern '" + exclude + "' for " + entry.getKey() + ".exclude"));
                    }
                }
            }
            filterDescriptors.add(new AnnotationFilterDescriptor(inclusionPatterns, exclusionPatterns, parameter));
        } else {
            switch (untypedEntry.getKey()) {
                case "typeMapping": {
                    Map.Entry<String, Object> entry = untypedEntry;
                    for (Map.Entry e : ((Map)entry.getValue()).entrySet()) {
                        this.addTypeMapping((String)e.getKey(), (String)e.getValue());
                    }
                    break;
                }
            }
        }
    }

    public void dumpOverloads(PrintStream out) {
        for (Map.Entry<TypeElement, Map<String, OverloadScanner.Overload>> e1 : this.overloads.entrySet()) {
            out.println("*** " + e1.getKey());
            for (Map.Entry<String, OverloadScanner.Overload> e2 : e1.getValue().entrySet()) {
                out.println("  - " + e2.getValue());
            }
        }
        for (Map.Entry<TypeElement, Map<String, OverloadScanner.Overload>> e1 : this.staticOverloads.entrySet()) {
            out.println("*** " + e1.getKey() + " [STATIC]");
            for (Map.Entry<String, OverloadScanner.Overload> e2 : e1.getValue().entrySet()) {
                out.println("  - " + e2.getValue());
            }
        }
    }

    public Set<OverloadScanner.Overload> getAllOverloads() {
        HashSet<OverloadScanner.Overload> result = new HashSet<OverloadScanner.Overload>();
        this.overloads.values().forEach(m -> result.addAll(m.values()));
        this.staticOverloads.values().forEach(m -> result.addAll(m.values()));
        return result;
    }

    public OverloadScanner.Overload getOrCreateOverload(TypeElement clazz, ExecutableElement method) {
        String name;
        OverloadScanner.Overload overload;
        Map<TypeElement, Map<String, OverloadScanner.Overload>> actualOverloads = method.getModifiers().contains((Object)Modifier.STATIC) ? this.staticOverloads : this.overloads;
        Map<String, OverloadScanner.Overload> m = actualOverloads.get(clazz);
        if (m == null) {
            m = new HashMap<String, OverloadScanner.Overload>();
            actualOverloads.put(clazz, m);
        }
        if ((overload = m.get(name = method.getSimpleName().toString())) == null) {
            overload = new OverloadScanner.Overload(this);
            overload.methodName = name;
            m.put(name, overload);
        }
        return overload;
    }

    public OverloadScanner.Overload getOverload(TypeElement clazz, ExecutableElement method) {
        Map<TypeElement, Map<String, OverloadScanner.Overload>> actualOverloads = method.getModifiers().contains((Object)Modifier.STATIC) ? this.staticOverloads : this.overloads;
        Map<String, OverloadScanner.Overload> m = actualOverloads.get(clazz);
        if (m == null) {
            return null;
        }
        OverloadScanner.Overload overload = m.get(method.getSimpleName().toString());
        if (overload == null) {
            return null;
        }
        return overload;
    }

    public boolean isInvalidOverload(ExecutableElement method) {
        OverloadScanner.Overload overload = this.getOverload((TypeElement)method.getEnclosingElement(), method);
        return overload != null && overload.getMethodsCount() > 1 && !overload.isValid;
    }

    public boolean isExcludedSourcePath(String sourcePath) {
        return this.excludedSourcePaths != null && this.excludedSourcePaths.contains(sourcePath);
    }

    public void countStaticInitializer(TypeElement clazz) {
        this.staticInitializerCounts.put(clazz, (this.staticInitializerCounts.containsKey(clazz) ? this.staticInitializerCounts.get(clazz) : 0) + 1);
    }

    public int getStaticInitializerCount(TypeElement clazz) {
        Integer count = null;
        count = this.staticInitializerCounts.get(clazz);
        return count == null ? 0 : count;
    }

    public void registerUsedModule(String moduleName) {
        if (!this.usedModules.contains(moduleName)) {
            this.usedModules.add(moduleName);
        }
    }

    public List<String> getUsedModules() {
        return this.usedModules;
    }

    public void registerImportedName(String moduleName, Element sourceElement, String targetName) {
        Set<String> importedNames = this.importedNamesInModules.get(moduleName);
        if (importedNames == null) {
            importedNames = new HashSet<String>();
            this.importedNamesInModules.put(moduleName, importedNames);
        }
        if (!importedNames.contains(targetName)) {
            importedNames.add(targetName);
        }
        if (sourceElement != null) {
            Map<Element, String> importedElements = this.importedElementsInModules.get(moduleName);
            if (importedElements == null) {
                importedElements = new HashMap<Element, String>();
                this.importedElementsInModules.put(moduleName, importedElements);
            }
            if (!importedElements.containsKey(sourceElement)) {
                importedElements.put(sourceElement, targetName);
            }
        }
    }

    public Set<String> getImportedNames(String moduleName) {
        Set<String> importedNames = this.importedNamesInModules.get(moduleName);
        if (importedNames == null) {
            importedNames = new HashSet<String>();
            this.importedNamesInModules.put(moduleName, importedNames);
        }
        return importedNames;
    }

    public Map<Element, String> getImportedElements(String moduleName) {
        Map<Element, String> importedElements = this.importedElementsInModules.get(moduleName);
        if (importedElements == null) {
            importedElements = new HashMap<Element, String>();
            this.importedElementsInModules.put(moduleName, importedElements);
        }
        return importedElements;
    }

    public void clearImportedNames(String moduleName) {
        HashSet importedNames = new HashSet();
        this.importedNamesInModules.put(moduleName, importedNames);
        HashMap importedModulesForNames = new HashMap();
        this.importedElementsInModules.put(moduleName, importedModulesForNames);
    }

    public Map<String, List<Element>> getExportedElements() {
        return this.exportedElements;
    }

    public String getExportedElementName(Element exportedElement) {
        String name = this.exportedNames.get(exportedElement);
        String forcedName = this.getAnnotationValue(exportedElement, "jsweet.lang.Module", "exportedElement", String.class, null);
        if (StringUtils.isNotBlank((CharSequence)forcedName)) {
            name = forcedName;
        }
        return name;
    }

    public void addExportedElement(String moduleName, Element exportedElement, CompilationUnitTree compilationUnit) {
        List<Element> exportedNamesForModule = this.exportedElements.get(moduleName);
        if (exportedNamesForModule == null) {
            exportedNamesForModule = new ArrayList<Element>();
            this.exportedElements.put(moduleName, exportedNamesForModule);
        }
        this.exportedNames.put(exportedElement, this.getRootRelativeName(this.useModules ? this.getImportedElements(compilationUnit.getSourceFile().getName()) : null, exportedElement));
        exportedNamesForModule.add(exportedElement);
    }

    public void clearFooterStatements() {
        this.footerStatements.clear();
    }

    public String getFooterStatements() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> footerStatement : this.footerStatements) {
            sb.append("\n");
            sb.append(footerStatement.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void addFooterStatement(String key, String footerStatement) {
        this.footerStatements.add(new AbstractMap.SimpleEntry<String, String>(key, footerStatement));
    }

    public void addFooterStatement(String footerStatement) {
        this.footerStatements.add(new AbstractMap.SimpleEntry<String, String>("", footerStatement));
    }

    public void addTopFooterStatement(String key, String footerStatement) {
        this.footerStatements.add(0, new AbstractMap.SimpleEntry<String, String>(key, footerStatement));
    }

    public void addTopFooterStatement(String footerStatement) {
        this.footerStatements.add(0, new AbstractMap.SimpleEntry<String, String>("", footerStatement));
    }

    public boolean forceTopImports() {
        this.forceTopImports = true;
        return this.forceTopImports;
    }

    public void clearHeaders() {
        this.headers.clear();
        this.forceTopImports = false;
    }

    public String getHeaders() {
        if (this.forceTopImports) {
            for (Map.Entry<String, String> statement : new ArrayList<Map.Entry<String, String>>(this.footerStatements)) {
                if (!statement.getKey().startsWith("import.")) continue;
                this.footerStatements.remove(statement);
                this.headers.put(statement.getKey(), statement.getValue());
            }
        }
        StringBuilder sb = new StringBuilder();
        if (!this.headers.isEmpty()) {
            for (String header : this.headers.values()) {
                sb.append(header);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void addHeader(String key, String header) {
        this.headers.put(key, header);
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public void addGlobalsMapping(String from, String to) {
        this.globalsMapping.put(from, to);
    }

    public void clearGlobalsMappings() {
        this.globalsMapping.clear();
    }

    public String getGlobalsMappingString() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, String> e : this.globalsMapping.entrySet()) {
            b.append("var " + e.getValue() + " = " + e.getKey() + ";\n");
        }
        return b.toString();
    }

    public Set<DefaultMethodEntry> getDefaultMethods(TypeElement type) {
        return this.defaultMethods.get(type);
    }

    public CompilationUnitTree getDefaultMethodCompilationUnit(MethodTree defaultMethod) {
        return this.defaultMethodsCompilationUnits.get(defaultMethod);
    }

    public void addDefaultMethod(CompilationUnitTree compilationUnit, ClassTree classTree, MethodTree defaultMethod) {
        TypeElement classElement = (TypeElement)Util.getElement(classTree);
        Set<DefaultMethodEntry> methods = this.defaultMethods.get(classElement);
        if (methods == null) {
            methods = new HashSet<DefaultMethodEntry>();
            this.defaultMethods.put(classElement, methods);
        }
        ExecutableElement methodElement = (ExecutableElement)Util.getElement(defaultMethod);
        TypeElement enclosingClassElement = (TypeElement)Util.getElement(classTree);
        methods.add(new DefaultMethodEntry(compilationUnit, classTree, enclosingClassElement, defaultMethod, methodElement));
        this.defaultMethodsCompilationUnits.put(defaultMethod, compilationUnit);
    }

    public void addFieldNameMapping(VariableElement field, String name) {
        this.fieldNameMapping.put(field, name);
    }

    public String getFieldNameMapping(VariableElement field) {
        return this.fieldNameMapping.get(field);
    }

    public boolean hasFieldNameMapping(VariableElement field) {
        return this.fieldNameMapping.containsKey(field);
    }

    public void addMethodNameMapping(ExecutableElement method, String name) {
        this.methodNameMapping.put(method, name);
    }

    public String getMethodNameMapping(Element method) {
        return this.methodNameMapping.get(method);
    }

    public boolean hasMethodNameMapping(Element method) {
        return this.methodNameMapping.containsKey(method);
    }

    public void addClassNameMapping(TypeElement clazz, String name) {
        this.classNameMapping.put(clazz, name);
    }

    public String getClassNameMapping(TypeElement clazz) {
        return this.classNameMapping.get(clazz);
    }

    public boolean hasClassNameMapping(TypeElement clazz) {
        return this.classNameMapping.containsKey(clazz);
    }

    public void registerWildcard(ExecutableElement holder, WildcardTree wildcard) {
        if (wildcard.getBound() == null) {
            return;
        }
        List<WildcardTree> l = this.wildcards.get(holder);
        if (l == null) {
            l = new ArrayList<WildcardTree>();
            this.wildcards.put(holder, l);
        }
        l.add(wildcard);
        this.wildcardNames.put(wildcard, "__T" + l.size());
    }

    public String getWildcardName(WildcardTree wildcard) {
        return this.wildcardNames.get(wildcard);
    }

    public List<WildcardTree> getWildcards(ExecutableElement holder) {
        return this.wildcards.get(holder);
    }

    public boolean isRootPackage(Element element) {
        return this.hasAnnotationType(element, "jsweet.lang.Root") || element instanceof PackageElement && libPackagePattern.matcher(((PackageElement)element).getQualifiedName().toString()).matches();
    }

    public boolean isInterface(Element typeElement) {
        return this.util.isInterface(typeElement) || this.hasAnnotationType(typeElement, "jsweet.lang.Interface");
    }

    public boolean elementHasAnnotationType(Element element, String ... annotationTypes) {
        return this.hasAnnotationType(element, annotationTypes);
    }

    public boolean hasAnnotationType(Element element, String ... annotationTypes) {
        if (element == null) {
            return false;
        }
        String[] types = annotationTypes;
        for (AnnotationManager annotationIntrospector : this.annotationManagers) {
            String[] stringArray = types;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String annotationType = stringArray[i];
                AnnotationManager.Action state = annotationIntrospector.manageAnnotation(element, annotationType);
                if (state == AnnotationManager.Action.ADD) {
                    return true;
                }
                if (state != AnnotationManager.Action.REMOVE) continue;
                types = (String[])ArrayUtils.removeElement((Object[])annotationTypes, (Object)annotationType);
            }
        }
        if (this.hasAnnotationFilters()) {
            String signature = this.getElementSignatureForAnnotationFilters(element);
            for (String annotationType : annotationTypes) {
                Collection<AnnotationFilterDescriptor> filterDescriptors = this.annotationFilters.get(annotationType);
                if (filterDescriptors == null) continue;
                for (AnnotationFilterDescriptor filterDescriptor : filterDescriptors) {
                    if (filterDescriptor.inclusionPatterns == null) {
                        logger.error((Object)("no inclusion patterns found for annotation filter: " + annotationType));
                    }
                    for (Pattern include : filterDescriptor.inclusionPatterns) {
                        if (!include.matcher(signature).matches()) continue;
                        boolean excluded = false;
                        Collection<Pattern> excludePatterns = filterDescriptor.exclusionPatterns;
                        if (excludePatterns != null) {
                            for (Pattern exclude : excludePatterns) {
                                if (!exclude.matcher(signature).matches()) continue;
                                excluded = true;
                                break;
                            }
                        }
                        if (excluded) continue;
                        return true;
                    }
                }
            }
        }
        if (this.extraAnnotations != null) {
            for (String annotationType : annotationTypes) {
                Set<Element> elements = this.extraAnnotations.get(annotationType);
                if (elements == null || !elements.contains(element)) continue;
                return true;
            }
        }
        return JSweetContext.hasActualAnnotationType(element, annotationTypes);
    }

    public void addExtraAnnotationType(Element symbol, String annotationTypeName) {
        Set<Element> elements;
        if (this.extraAnnotations == null) {
            this.extraAnnotations = new HashMap<String, Set<Element>>();
        }
        if ((elements = this.extraAnnotations.get(annotationTypeName)) == null) {
            elements = new HashSet<Element>();
            this.extraAnnotations.put(annotationTypeName, elements);
        }
        elements.add(symbol);
    }

    private String getElementSignatureForAnnotationFilters(Element element) {
        String enclosingQualifiedName;
        Object signature = element.toString();
        if (!(element instanceof TypeElement) && element.getEnclosingElement() != null && StringUtils.isNotBlank((CharSequence)(enclosingQualifiedName = this.util.getQualifiedName(element.getEnclosingElement())))) {
            signature = enclosingQualifiedName + "." + (String)signature;
        }
        return signature;
    }

    public String getActualName(Element symbol) {
        String name = symbol.getSimpleName().toString();
        String originalName = "";
        if (this.hasAnnotationType(symbol, "jsweet.lang.Name")) {
            originalName = this.getAnnotationValue(symbol, "jsweet.lang.Name", String.class, null);
        }
        if (!StringUtils.isBlank((CharSequence)originalName)) {
            name = originalName;
        } else if (this.hasMethodNameMapping(symbol)) {
            name = this.getMethodNameMapping(symbol);
        }
        return name;
    }

    private void getRootRelativeName(Map<Element, String> nameMapping, StringBuilder sb, Element element) {
        if (element == null || this.useModules && element instanceof PackageElement && !element.toString().startsWith("def.")) {
            return;
        }
        if (!this.isRootPackage(element)) {
            if (sb.length() > 0 && !"".equals(element.toString())) {
                sb.insert(0, ".");
            }
            String name = element.getSimpleName().toString();
            if (nameMapping != null && nameMapping.containsKey(element)) {
                name = nameMapping.get(element);
            } else if (this.hasAnnotationType(element, "jsweet.lang.Name")) {
                String originalName = this.getAnnotationValue(element, "jsweet.lang.Name", String.class, null);
                if (!StringUtils.isBlank((CharSequence)originalName)) {
                    name = originalName;
                }
            } else if (element.getKind() == ElementKind.PACKAGE) {
                name = this.avoidJSKeyword(name);
            }
            sb.insert(0, name);
            Element element2 = element = element instanceof PackageElement ? this.util.getParentPackage((PackageElement)element) : element.getEnclosingElement();
            if (element != null) {
                this.getRootRelativeName(nameMapping, sb, element);
            }
        }
    }

    private String avoidJSKeyword(String name) {
        if (JSweetConfig.JS_KEYWORDS.contains(name)) {
            name = "__" + (String)name;
        }
        return name;
    }

    public PackageElement getTopLevelPackage(Element element) {
        Element parent;
        if (element == null || element instanceof PackageElement && this.isRootPackage(element)) {
            return null;
        }
        Element element2 = parent = element instanceof PackageElement ? this.util.getParentPackage((PackageElement)element) : element.getEnclosingElement();
        if (parent != null && this.isRootPackage(parent)) {
            if (element instanceof PackageElement) {
                return (PackageElement)element;
            }
            return null;
        }
        if (parent == null || parent instanceof PackageElement && StringUtils.isBlank((CharSequence)parent.getSimpleName())) {
            if (element instanceof PackageElement) {
                return (PackageElement)element;
            }
            return null;
        }
        return this.getTopLevelPackage(parent);
    }

    public PackageElement getFirstEnclosingRootPackage(PackageElement packageElement) {
        if (packageElement == null) {
            return null;
        }
        if (this.isRootPackage(packageElement)) {
            return packageElement;
        }
        return this.getFirstEnclosingRootPackage(this.util.getParentPackage(packageElement));
    }

    private void getRootRelativeJavaName(StringBuilder sb, Element element) {
        if (!this.isRootPackage(element)) {
            if (sb.length() > 0 && !"".equals(element.toString())) {
                sb.insert(0, ".");
            }
            String name = element.getSimpleName().toString();
            sb.insert(0, name);
            Element element2 = element = element instanceof PackageElement ? this.util.getParentPackage((PackageElement)element) : element.getEnclosingElement();
            if (element != null) {
                this.getRootRelativeJavaName(sb, element);
            }
        }
    }

    public String getRootRelativeName(Map<Element, String> nameMapping, Element symbol, boolean useJavaNames) {
        if (useJavaNames) {
            return this.getRootRelativeJavaName(symbol);
        }
        return this.getRootRelativeName(nameMapping, symbol);
    }

    public String getRootRelativeName(Map<Element, String> nameMapping, Element symbol) {
        StringBuilder sb = new StringBuilder();
        this.getRootRelativeName(nameMapping, sb, symbol);
        if (sb.length() > 0 && sb.charAt(0) == '.') {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public String getRootRelativeJavaName(Element symbol) {
        StringBuilder sb = new StringBuilder();
        this.getRootRelativeJavaName(sb, symbol);
        return sb.toString();
    }

    public final <T> T getAnnotationValue(Element symbol, String annotationType, Class<T> propertyClass, T defaultValue) {
        return this.getAnnotationValue(symbol, annotationType, null, propertyClass, defaultValue);
    }

    public <T> T getAnnotationValue(Element element, String annotationType, String propertyName, Class<T> propertyClass, T defaultValue) {
        Object firstVal;
        for (AnnotationManager annotationIntrospector : this.annotationManagers) {
            Object value = annotationIntrospector.getAnnotationValue(element, annotationType, propertyName, propertyClass, defaultValue);
            if (value == null) continue;
            return value;
        }
        if (this.hasAnnotationFilters()) {
            String signature = this.getElementSignatureForAnnotationFilters(element);
            Collection<AnnotationFilterDescriptor> filterDescriptors = this.annotationFilters.get(annotationType);
            if (filterDescriptors != null) {
                for (AnnotationFilterDescriptor filterDescriptor : filterDescriptors) {
                    for (Pattern include : filterDescriptor.inclusionPatterns) {
                        if (!include.matcher(signature).matches()) continue;
                        boolean excluded = false;
                        Collection<Pattern> excludePatterns = filterDescriptor.exclusionPatterns;
                        if (excludePatterns != null) {
                            for (Pattern exclude : excludePatterns) {
                                if (!exclude.matcher(signature).matches()) continue;
                                excluded = true;
                                break;
                            }
                        }
                        if (excluded) continue;
                        if (filterDescriptor.parameter == null) {
                            return defaultValue;
                        }
                        if (filterDescriptor.parameter.startsWith("'")) {
                            return (T)filterDescriptor.parameter.substring(1, filterDescriptor.parameter.length() - 1);
                        }
                        if (filterDescriptor.parameter.endsWith(".class")) {
                            return (T)filterDescriptor.parameter.substring(0, filterDescriptor.parameter.length() - 6);
                        }
                        return (T)filterDescriptor.parameter;
                    }
                }
            }
        }
        AnnotationMirror anno = this.getAnnotation(element, annotationType);
        T val = defaultValue;
        if (anno != null && (firstVal = JSweetContext.getFirstAnnotationValue(anno, propertyName, propertyClass, null)) != null) {
            val = firstVal;
        }
        return val;
    }

    private static <T> T getFirstAnnotationValue(AnnotationMirror annotation, String propertyName, Class<T> propertyClass, T defaultValue) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> valueEntry : annotation.getElementValues().entrySet()) {
            if (propertyName != null && !propertyName.equals(valueEntry.getKey().getSimpleName().toString())) continue;
            if (propertyClass.isArray()) {
                List annotationValues = (List)valueEntry.getValue().getValue();
                Object array = Array.newInstance(propertyClass.getComponentType(), annotationValues.size());
                for (int i = 0; i < annotationValues.size(); ++i) {
                    Array.set(array, i, ((AnnotationValue)annotationValues.get(i)).getValue());
                }
                return (T)array;
            }
            return (T)valueEntry.getValue().getValue();
        }
        return defaultValue;
    }

    private AnnotationMirror getAnnotation(Element symbol, String annotationType) {
        for (AnnotationMirror annotationMirror : symbol.getAnnotationMirrors()) {
            if (!annotationType.equals(annotationMirror.getAnnotationType().toString())) continue;
            return annotationMirror;
        }
        return null;
    }

    public void grabSupportedInterfaceNames(Set<String> interfaces, TypeElement type, PrinterAdapter adapter) {
        if (type == null) {
            return;
        }
        if (this.isInterface(type) && !this.hasAnnotationType(type, "jsweet.lang.Erased")) {
            interfaces.add(type.getQualifiedName().toString());
        }
        if (type instanceof TypeElement) {
            for (TypeElement interfaceType : this.util.getInterfaces(type)) {
                if (interfaceType == null || adapter.eraseSuperInterface(type, interfaceType)) continue;
                this.grabSupportedInterfaceNames(interfaces, interfaceType, adapter);
            }
            TypeElement superClassType = (TypeElement)Util.getElement(type.getSuperclass());
            if (superClassType != null && !adapter.eraseSuperInterface(type, superClassType)) {
                this.grabSupportedInterfaceNames(interfaces, superClassType, adapter);
            }
        }
    }

    public void grabSuperClassNames(Set<String> superClasses, Element type) {
        if (type == null) {
            return;
        }
        if (type instanceof TypeElement) {
            superClasses.add(((TypeElement)type).getQualifiedName().toString());
            this.grabSuperClassNames(superClasses, this.util.getSuperclass((TypeElement)type));
        }
    }

    public void grabMethodsToBeImplemented(List<ExecutableElement> methods, TypeElement type) {
        if (type == null) {
            return;
        }
        if (this.isInterface(type)) {
            for (Element element : type.getEnclosedElements()) {
                if (!(element instanceof ExecutableElement) || element.getModifiers().contains((Object)Modifier.STATIC) || this.util.isOverridingBuiltInJavaObjectMethod((ExecutableElement)element)) continue;
                methods.add((ExecutableElement)element);
            }
        }
        if (type instanceof TypeElement) {
            for (TypeElement typeElement : this.util.getInterfaces(type)) {
                this.grabMethodsToBeImplemented(methods, typeElement);
            }
            this.grabMethodsToBeImplemented(methods, this.util.getSuperclass(type));
        }
    }

    private static boolean hasActualAnnotationType(Element symbol, String ... annotationTypes) {
        for (AnnotationMirror annotationMirror : symbol.getAnnotationMirrors()) {
            for (String annotationType : annotationTypes) {
                if (!annotationType.equals(annotationMirror.getAnnotationType().toString())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAnonymousClass(NewClassTree newClass, CompilationUnitTree compilationUnit) {
        if (newClass.getIdentifier() != null && newClass.getClassBody() != null) {
            TypeElement newClassTypeElement = (TypeElement)Util.getTypeElement(newClass.getIdentifier());
            if (this.hasAnnotationType(newClassTypeElement, "jsweet.lang.ObjectType") || this.hasAnnotationType(newClassTypeElement, "jsweet.lang.Interface")) {
                return false;
            }
            if (newClass.getClassBody().getMembers().size() > 2) {
                return true;
            }
            if (newClassTypeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return true;
            }
            for (Tree tree : newClass.getClassBody().getMembers()) {
                MethodTree methodTree;
                ExecutableElement executableElement;
                if (tree instanceof VariableTree) {
                    return true;
                }
                if (tree instanceof MethodTree && ((executableElement = (ExecutableElement)Util.getElement(methodTree = (MethodTree)tree)).getKind() != ElementKind.CONSTRUCTOR || !executableElement.getParameters().isEmpty())) {
                    return true;
                }
                if (!(tree instanceof BlockTree)) continue;
                for (StatementTree statementTree : ((BlockTree)tree).getStatements()) {
                    if (JSweetContext.isAllowedStatementInMap(statementTree)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isAllowedStatementInMap(StatementTree statement) {
        if (statement instanceof ExpressionStatementTree) {
            MethodInvocationTree inv;
            String methodName;
            ExpressionStatementTree exprStat = (ExpressionStatementTree)statement;
            if (exprStat.getExpression() instanceof AssignmentTree) {
                return true;
            }
            if (exprStat.getExpression() instanceof MethodInvocationTree && ("$get".equals(methodName = (inv = (MethodInvocationTree)exprStat.getExpression()).getMethodSelect() instanceof MemberSelectTree ? ((MemberSelectTree)inv.getMethodSelect()).getIdentifier().toString() : inv.getMethodSelect().toString()) || "$set".equals(methodName))) {
                return true;
            }
        }
        return false;
    }

    public int getFunctionalTypeParameterCount(TypeMirror type) {
        Element typeElement = this.types.asElement(type);
        String name = typeElement.getSimpleName().toString();
        String fullName = type.toString();
        if (Runnable.class.getName().equals(fullName)) {
            return 0;
        }
        if (type.toString().startsWith("jsweet.util.function.")) {
            if (name.equals("TriFunction")) {
                return 3;
            }
            if (name.equals("TriConsumer")) {
                return 3;
            }
            if (name.equals("Consumer")) {
                return 1;
            }
            if (name.startsWith("Function") || name.startsWith("Consumer")) {
                return Integer.parseInt(name.substring(8));
            }
            return -1;
        }
        if (type.toString().startsWith("java.util.function.")) {
            if (name.endsWith("Consumer")) {
                if (name.startsWith("Bi")) {
                    return 2;
                }
                return 1;
            }
            if (name.endsWith("Function")) {
                if (name.startsWith("Bi")) {
                    return 2;
                }
                return 1;
            }
            if (name.endsWith("UnaryOperator")) {
                return 1;
            }
            if (name.endsWith("BinaryOperator")) {
                return 2;
            }
            if (name.endsWith("Supplier")) {
                return 0;
            }
            if (name.endsWith("Predicate")) {
                if (name.startsWith("Bi")) {
                    return 2;
                }
                return 1;
            }
            return -1;
        }
        if (this.hasAnnotationType(typeElement, JSweetConfig.ANNOTATION_FUNCTIONAL_INTERFACE)) {
            for (Element element : typeElement.getEnclosedElements()) {
                if (!(element instanceof ExecutableElement)) continue;
                return ((ExecutableElement)element).getParameters().size();
            }
            return -1;
        }
        return -1;
    }

    public boolean isFunctionalType(Element typeElement) {
        if (typeElement == null) {
            return false;
        }
        String name = this.util.getQualifiedName(typeElement);
        return name.startsWith("java.util.function.") || name.equals(Runnable.class.getName()) || name.startsWith("jsweet.util.function.") || this.util.isInterface(typeElement) && (this.hasAnnotationType(typeElement, FunctionalInterface.class.getName()) || this.hasAnonymousFunction(typeElement));
    }

    public boolean isCoreFunctionalType(TypeElement type) {
        String name = type.getQualifiedName().toString();
        return name.startsWith("java.util.function.") || name.equals(Runnable.class.getName()) || name.startsWith("jsweet.util.function.") || this.util.isInterface(type) && this.hasAnonymousFunction(type);
    }

    public boolean hasAnonymousFunction(Element type) {
        for (Element element : type.getEnclosedElements()) {
            String methodName;
            if (!(element instanceof ExecutableElement) || !"$apply".equals(methodName = element.getSimpleName().toString()) && (!this.deprecatedApply || !"apply".equals(methodName))) continue;
            return true;
        }
        return false;
    }

    public boolean isIgnored(ClassTree classdecl, CompilationUnitTree compilationUnit) {
        Object classElement = Util.getElement(classdecl);
        if (this.hasAnnotationType((Element)classElement, "jsweet.lang.ObjectType")) {
            return true;
        }
        if (this.hasAnnotationType((Element)classElement, "jsweet.lang.Erased")) {
            return true;
        }
        return classElement.getKind() == ElementKind.ANNOTATION_TYPE && !this.hasAnnotationType((Element)classElement, "jsweet.lang.Decorator");
    }

    public boolean isPackageErased(PackageElement pkg) {
        if (pkg == null) {
            return false;
        }
        if (this.hasAnnotationType(pkg, "jsweet.lang.Erased")) {
            return true;
        }
        return this.isPackageErased(this.util.getParentPackage(pkg));
    }

    public boolean isUsingJavaRuntime() {
        return this.usingJavaRuntime;
    }

    public void setUsingJavaRuntime(boolean usingJavaRuntime) {
        this.usingJavaRuntime = usingJavaRuntime;
    }

    public final Map<String, String> getLangTypeMappings() {
        return this.langTypesMapping;
    }

    public final Set<String> getLangTypesSimpleNames() {
        return this.langTypesSimpleNames;
    }

    public final Set<String> getBaseThrowables() {
        return this.baseThrowables;
    }

    private boolean isAmbientAnnotatedDeclaration(Element symbol) {
        if (symbol == null) {
            return false;
        }
        if (this.hasAnnotationType(symbol, "jsweet.lang.Ambient")) {
            return true;
        }
        return this.isAmbientAnnotatedDeclaration(symbol.getEnclosingElement());
    }

    public boolean isAmbientDeclaration(Element element) {
        if (this.util.getQualifiedName(element).startsWith("def.")) {
            return true;
        }
        return this.isAmbientAnnotatedDeclaration(element);
    }

    public void registerTreeCompilationUnit(Tree tree, CompilationUnitTree compilationUnit) {
        this.compilationUnitsMapping.put(tree, compilationUnit);
    }

    public void registerMethodTreeCompilationUnit(MethodTree methodTree, CompilationUnitTree compilationUnit) {
        this.registerTreeCompilationUnit(methodTree, compilationUnit);
        this.registerTreeCompilationUnit(methodTree.getReturnType(), compilationUnit);
        for (VariableTree variableTree : methodTree.getParameters()) {
            this.registerTreeCompilationUnit(variableTree, compilationUnit);
        }
    }

    public void addAwaitInvocation(MethodInvocationTree invocation) {
        if (this.awaitInvocations == null) {
            this.awaitInvocations = new HashSet<MethodInvocationTree>();
        }
        this.awaitInvocations.add(invocation);
    }

    public boolean isAwaitInvocation(MethodInvocationTree invocation) {
        if (this.awaitInvocations != null) {
            return this.awaitInvocations.contains(invocation);
        }
        return false;
    }

    public static class GlobalMethodInfos {
        public final ClassTree classTree;
        public final MethodTree methodTree;
        public final CompilationUnitTree compilationUnitTree;

        private GlobalMethodInfos(ClassTree classTree, MethodTree methodTree, CompilationUnitTree compilationUnitTree) {
            this.classTree = classTree;
            this.methodTree = methodTree;
            this.compilationUnitTree = compilationUnitTree;
        }
    }

    private static class AnnotationFilterDescriptor {
        public final Collection<Pattern> inclusionPatterns;
        public final Collection<Pattern> exclusionPatterns;
        public final String parameter;

        public AnnotationFilterDescriptor(Collection<Pattern> inclusionPatterns, Collection<Pattern> exclusionPatterns, String parameter) {
            this.inclusionPatterns = inclusionPatterns;
            this.exclusionPatterns = exclusionPatterns;
            this.parameter = parameter;
        }

        public String toString() {
            return "FILTER" + (String)(this.parameter == null ? "" : "('" + this.parameter + "')") + ": INCLUDES=" + this.inclusionPatterns + ", EXCLUDES=" + this.exclusionPatterns;
        }
    }

    public static class DefaultMethodEntry {
        public final CompilationUnitTree compilationUnit;
        public final ClassTree enclosingClassTree;
        public final TypeElement enclosingClassElement;
        public final MethodTree methodTree;
        public final ExecutableElement methodElement;
        public final ExecutableType methodType;

        protected DefaultMethodEntry(CompilationUnitTree compilationUnit, ClassTree enclosingClassTree, TypeElement enclosingClassElement, MethodTree methodTree, ExecutableElement methodElement) {
            this.compilationUnit = compilationUnit;
            this.enclosingClassTree = enclosingClassTree;
            this.enclosingClassElement = enclosingClassElement;
            this.methodTree = methodTree;
            this.methodElement = methodElement;
            this.methodType = (ExecutableType)methodElement.asType();
        }

        public int hashCode() {
            return this.methodTree.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof DefaultMethodEntry && this.methodTree == ((DefaultMethodEntry)other).methodTree;
        }
    }
}

