/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.Trees;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.StringUtils;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.util.AbstractTreeScanner;
import org.jsweet.transpiler.util.Util;

public class GlobalBeforeTranslationScanner
extends AbstractTreeScanner {
    private Map<VariableTree, TypeElement> lazyInitializedStaticCandidates = new HashMap<VariableTree, TypeElement>();

    public GlobalBeforeTranslationScanner(TranspilationHandler logHandler, JSweetContext context) {
        super(logHandler, context, null);
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree compilationUnit, Trees trees) {
        if (this.util().getPackageFullNameForCompilationUnit(compilationUnit).startsWith("def.")) {
            return null;
        }
        this.compilationUnit = compilationUnit;
        return (Void)super.visitCompilationUnit(compilationUnit, trees);
    }

    @Override
    public Void visitClass(ClassTree classDeclaration, Trees trees) {
        TypeMirror superClassType;
        TypeElement classElement = (TypeElement)Util.getElement(classDeclaration);
        String docComment = trees.getDocComment(trees.getPath(this.compilationUnit, classDeclaration));
        if (StringUtils.isNotBlank((CharSequence)docComment)) {
            this.context.docComments.put(classElement, docComment);
        }
        if ((superClassType = this.context.types.erasure(classElement.getSuperclass())).toString().startsWith("java.") && !superClassType.toString().equals(Object.class.getName()) && !this.types().isSubtype(classElement.asType(), this.util().getType(Throwable.class)) && !this.util().isSourceElement(this.types().asElement(superClassType))) {
            this.context.addJdkSubclass(classElement.toString(), superClassType);
        }
        this.transposeInnerClassNameIfClash(classDeclaration, classElement);
        if (!(classElement.getEnclosingElement() instanceof TypeElement) && classElement.getKind() == ElementKind.ANNOTATION_TYPE && this.context.hasAnnotationType(classElement, "jsweet.lang.Decorator")) {
            this.context.registerDecoratorAnnotation(classDeclaration, this.compilationUnit);
        }
        boolean globals = false;
        if ("Globals".equals(classDeclaration.getSimpleName().toString())) {
            globals = true;
        }
        for (Tree tree : classDeclaration.getMembers()) {
            ExecutableElement clashingMethod;
            Object methodElement;
            if (tree instanceof VariableTree) {
                VariableTree fieldDeclaration = (VariableTree)tree;
                VariableElement fieldElement = (VariableElement)Util.getElement(fieldDeclaration);
                String fieldDocComment = trees.getDocComment(trees.getPath(this.compilationUnit, fieldDeclaration));
                if (StringUtils.isNotBlank((CharSequence)docComment)) {
                    this.context.docComments.put(fieldElement, fieldDocComment);
                }
                this.transposeFieldNameIfClash(classElement, fieldDeclaration, fieldElement);
                if (!(!fieldDeclaration.getModifiers().getFlags().contains((Object)Modifier.STATIC) || fieldDeclaration.getModifiers().getFlags().contains((Object)Modifier.FINAL) && fieldDeclaration.getInitializer() != null && fieldDeclaration.getInitializer() instanceof LiteralTree)) {
                    this.lazyInitializedStaticCandidates.put(fieldDeclaration, classElement);
                }
            } else if (tree instanceof BlockTree && ((BlockTree)tree).isStatic()) {
                this.context.countStaticInitializer(classElement);
            }
            if (!(tree instanceof MethodTree) || (methodElement = Util.getElement(tree)) == null) continue;
            if (globals && methodElement.getModifiers().contains((Object)Modifier.STATIC)) {
                this.context.registerGlobalMethod(classDeclaration, (MethodTree)tree, this.compilationUnit);
                continue;
            }
            MethodTree method = (MethodTree)tree;
            TypeElement superClassTypeElement = (TypeElement)this.types().asElement(classElement.getSuperclass());
            if (methodElement instanceof ExecutableElement && methodElement.getModifiers().contains((Object)Modifier.PRIVATE) && methodElement.getKind() != ElementKind.STATIC_INIT && methodElement.getKind() != ElementKind.INSTANCE_INIT && !methodElement.getModifiers().contains((Object)Modifier.STATIC) && methodElement.getKind() != ElementKind.CONSTRUCTOR && (clashingMethod = this.util().findMethodDeclarationInType2(superClassTypeElement, method.getName().toString(), (ExecutableType)methodElement.asType())) != null && clashingMethod.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.context.addMethodNameMapping((ExecutableElement)methodElement, "__" + classElement.toString().replace(".", "_") + "_" + method.getName().toString());
            }
            VariableElement clashingField = null;
            clashingField = this.util().findFieldDeclaration(superClassTypeElement, method.getName());
            if (clashingField == null || !clashingField.getModifiers().contains((Object)Modifier.PRIVATE) || this.context.hasFieldNameMapping(clashingField)) continue;
            this.context.addFieldNameMapping(clashingField, "__" + classElement.toString().replace(".", "_") + "_" + method.getName().toString());
        }
        return (Void)super.visitClass(classDeclaration, trees);
    }

    private void transposeFieldNameIfClash(TypeElement classElement, VariableTree fieldDeclaration, VariableElement fieldElement) {
        Element superClassElement;
        if (!this.context.hasFieldNameMapping(fieldElement) && classElement.getSuperclass() != null && (superClassElement = this.types().asElement(classElement.getSuperclass())) instanceof TypeElement) {
            ExecutableElement m;
            VariableElement clashingField = this.util().findFieldDeclaration((TypeElement)superClassElement, fieldDeclaration.getName());
            if (clashingField != null && clashingField.getModifiers().contains((Object)Modifier.PRIVATE) && !this.context.hasFieldNameMapping(clashingField)) {
                this.context.addFieldNameMapping(fieldElement, "__" + classElement.toString().replace(".", "_") + "_" + fieldDeclaration.getName().toString());
            }
            if ((m = this.util().findMethodDeclarationInType(classElement, fieldDeclaration.getName().toString(), null)) != null) {
                this.context.addFieldNameMapping(fieldElement, "__" + fieldDeclaration.getName().toString());
            }
        }
    }

    private void transposeInnerClassNameIfClash(ClassTree classDeclaration, TypeElement classElement) {
        TypeElement enclosingClassElement;
        TypeMirror superClass;
        if (classElement.getEnclosingElement() instanceof TypeElement && (superClass = (enclosingClassElement = (TypeElement)classElement.getEnclosingElement()).getSuperclass()) != null) {
            TypeElement superClassElement = (TypeElement)this.types().asElement(superClass);
            TypeElement clashingInnerClass = this.util().findInnerClassDeclaration(superClassElement, classDeclaration.getSimpleName().toString());
            if (clashingInnerClass != null && !this.context.hasClassNameMapping(clashingInnerClass)) {
                this.context.addClassNameMapping(classElement, "__" + enclosingClassElement.getQualifiedName().toString().replace('.', '_') + "_" + clashingInnerClass.getSimpleName());
            }
        }
    }

    @Override
    public Void visitMethod(MethodTree methodDeclaration, Trees trees) {
        String docComment = trees.getDocComment(trees.getPath(this.compilationUnit, methodDeclaration));
        if (StringUtils.isNotBlank((CharSequence)docComment)) {
            ExecutableElement methodElement = (ExecutableElement)Util.getElement(methodDeclaration);
            this.context.docComments.put(methodElement, docComment);
        }
        if (methodDeclaration.getModifiers().getFlags().contains((Object)Modifier.DEFAULT)) {
            this.getContext().addDefaultMethod(this.compilationUnit, this.getParent(ClassTree.class), methodDeclaration);
        }
        if (!this.getContext().ignoreWildcardBounds) {
            this.scan(methodDeclaration.getParameters(), trees);
        }
        return null;
    }

    @Override
    public Void visitWildcard(WildcardTree wildcard, Trees trees) {
        ExecutableElement container = null;
        MethodTree method = this.getParent(MethodTree.class);
        if (method != null) {
            container = (ExecutableElement)Util.getElement(method);
        }
        if (container != null) {
            this.getContext().registerWildcard(container, wildcard);
            this.scan(wildcard.getBound(), trees);
        }
        return null;
    }

    public void process(List<CompilationUnitTree> compilationUnits) {
        for (CompilationUnitTree compilationUnitTree : compilationUnits) {
            this.scan((Tree)compilationUnitTree, this.trees());
        }
        for (Map.Entry entry : this.lazyInitializedStaticCandidates.entrySet()) {
            VariableTree var = (VariableTree)entry.getKey();
            TypeElement enclosingClass = (TypeElement)entry.getValue();
            if (this.context.getStaticInitializerCount(enclosingClass) == 0 && var.getInitializer() == null || this.util().isLiteralExpression(var.getInitializer())) continue;
            VariableElement varElement = (VariableElement)Util.getElement(var);
            this.context.lazyInitializedStatics.add(varElement);
        }
    }
}

