/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.util.Util;

public class ConstAnalyzer
extends TreeScanner<Void, Trees> {
    private Set<VariableElement> modifiedVariables = new HashSet<VariableElement>();
    private ElementKind variableKind = ElementKind.LOCAL_VARIABLE;
    private boolean initializationOnly = false;

    public Set<VariableElement> getModifiedVariables() {
        return this.modifiedVariables;
    }

    public ConstAnalyzer() {
    }

    public ConstAnalyzer(ElementKind variableKind, boolean initializationOnly) {
        this.variableKind = variableKind;
        this.initializationOnly = initializationOnly;
    }

    private void registerModification(Tree tree) {
        if (tree instanceof ArrayAccessTree) {
            return;
        }
        Object element = Util.getElement(tree);
        if (element != null && (this.variableKind == null || element.getKind() == this.variableKind)) {
            this.modifiedVariables.add((VariableElement)element);
        }
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree compilationUnit, Trees trees) {
        JSweetContext.currentCompilationUnit.set(compilationUnit);
        return (Void)super.visitCompilationUnit(compilationUnit, trees);
    }

    @Override
    public Void visitAssignment(AssignmentTree assign, Trees trees) {
        this.registerModification(assign.getVariable());
        return (Void)super.visitAssignment(assign, trees);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree assign, Trees trees) {
        if (!this.initializationOnly) {
            this.registerModification(assign.getVariable());
        }
        return (Void)super.visitCompoundAssignment(assign, trees);
    }

    @Override
    public Void visitUnary(UnaryTree unary, Trees trees) {
        switch (unary.getKind()) {
            case POSTFIX_DECREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_INCREMENT: {
                if (this.initializationOnly) break;
                this.registerModification(unary.getExpression());
            }
        }
        return (Void)super.visitUnary(unary, trees);
    }

    public void process(List<CompilationUnitTree> cuList, Trees trees) {
        for (CompilationUnitTree cu : cuList) {
            this.scan(cu, trees);
        }
    }
}

