/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.OverloadScanner;
import org.jsweet.transpiler.util.AbstractTreeScanner;
import org.jsweet.transpiler.util.Util;

public class AsyncAwaitPropagationScanner
extends AbstractTreeScanner {
    boolean stillWorking = false;

    public AsyncAwaitPropagationScanner(JSweetContext context) {
        super(null, context, null);
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree topLevel, Trees trees) {
        String packageFullName = this.util().getPackageFullNameForCompilationUnit(topLevel);
        if (packageFullName.startsWith("def.")) {
            return null;
        }
        this.compilationUnit = topLevel;
        return (Void)super.visitCompilationUnit(topLevel, trees);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree invocation, Trees trees) {
        try {
            ExecutableElement method = (ExecutableElement)Util.getElement(invocation.getMethodSelect());
            if (method == null) {
                return null;
            }
            if (this.context.hasAnnotationType(method, "jsweet.lang.Async") && !"void".equals(method.getReturnType().toString())) {
                ExecutableElement parentMethodElement;
                MethodTree parent = this.getParent(MethodTree.class);
                if (parent != null && !this.context.hasAnnotationType(parentMethodElement = (ExecutableElement)Util.getElement(parent), "jsweet.lang.Async")) {
                    this.context.addExtraAnnotationType(parentMethodElement, "jsweet.lang.Async");
                    if (this.context.isInvalidOverload(parentMethodElement)) {
                        OverloadScanner.Overload overload = this.context.getOverload((TypeElement)parentMethodElement.getEnclosingElement(), parentMethodElement);
                        for (OverloadScanner.OverloadMethodEntry overloadEntry : overload.getEntries()) {
                            this.context.addExtraAnnotationType(overloadEntry.methodElement, "jsweet.lang.Async");
                        }
                    }
                    ArrayList<ExecutableElement> candidates = new ArrayList<ExecutableElement>();
                    this.util().collectMatchingMethodDeclarationsInType((TypeElement)parentMethodElement.getEnclosingElement(), parent.getName().toString(), (ExecutableType)parentMethodElement.asType(), true, candidates);
                    for (ExecutableElement candidate : candidates) {
                        this.context.addExtraAnnotationType(candidate, "jsweet.lang.Async");
                    }
                    this.stillWorking = true;
                }
                Tree directParent = this.getParent();
                if (!(this.context.isAwaitInvocation(invocation) || directParent instanceof MethodInvocationTree && (Util.getElement(directParent).toString().equals("await") || Util.getElement((MethodInvocationTree)directParent).toString().endsWith(".await")))) {
                    this.context.addAwaitInvocation(invocation);
                    this.stillWorking = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (Void)super.visitMethodInvocation(invocation, trees);
    }

    public void process(List<CompilationUnitTree> compilationUnits, Trees trees) {
        do {
            this.stillWorking = false;
            for (CompilationUnitTree compilationUnit : compilationUnits) {
                this.scan((Tree)compilationUnit, trees);
            }
        } while (this.stillWorking);
    }
}

