/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.annotations.spring.config;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.jsr107.ri.annotations.CacheContextSource;
import org.jsr107.ri.annotations.InterceptorType;
import org.jsr107.ri.annotations.StaticCacheInvocationContext;
import org.jsr107.ri.annotations.spring.CacheMethodInterceptor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.util.Assert;

public class CacheStaticMethodMatcherPointcut
extends StaticMethodMatcherPointcut {
    private final CacheContextSource<MethodInvocation> cacheContextSource;
    private final InterceptorType interceptorType;

    public CacheStaticMethodMatcherPointcut(CacheContextSource<MethodInvocation> cacheContextSource, CacheMethodInterceptor cacheInterceptor) {
        Assert.notNull(cacheContextSource);
        Assert.notNull((Object)cacheInterceptor);
        this.cacheContextSource = cacheContextSource;
        this.interceptorType = cacheInterceptor.getInterceptorType();
    }

    public boolean matches(Method method, Class<?> targetClass) {
        StaticCacheInvocationContext methodDetails = this.cacheContextSource.getMethodDetails(method, targetClass);
        return methodDetails != null && methodDetails.getInterceptorType() == this.interceptorType;
    }
}

