/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.annotations.spring.config;

import org.jsr107.ri.annotations.AbstractCacheInterceptor;
import org.jsr107.ri.annotations.DefaultCacheKeyGenerator;
import org.jsr107.ri.annotations.DefaultCacheResolverFactory;
import org.jsr107.ri.annotations.spring.CacheContextSourceImpl;
import org.jsr107.ri.annotations.spring.CachePutInterceptor;
import org.jsr107.ri.annotations.spring.CacheRemoveAllInterceptor;
import org.jsr107.ri.annotations.spring.CacheRemoveEntryInterceptor;
import org.jsr107.ri.annotations.spring.CacheResultInterceptor;
import org.jsr107.ri.annotations.spring.config.CacheStaticMethodMatcherPointcut;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AnnotationDrivenJCacheBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String XSD_ATTR_CACHE_MANAGER = "cache-manager";
    private static final String JCACHE_CACHE_OPERATION_SOURCE_BEAN_NAME = AnnotationDrivenJCacheBeanDefinitionParser.class.getPackage().getName() + ".internalJCacheOperationSourceAdvisor";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Element)element);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (!registry.containsBeanDefinition(JCACHE_CACHE_OPERATION_SOURCE_BEAN_NAME)) {
            Object elementSource = parserContext.extractSource((Object)element);
            RuntimeBeanReference cacheOperationSourceReference = this.setupCacheOperationSource(element, parserContext, elementSource);
            this.setupPointcutAdvisor(CacheResultInterceptor.class, element, parserContext, elementSource, cacheOperationSourceReference);
            this.setupPointcutAdvisor(CachePutInterceptor.class, element, parserContext, elementSource, cacheOperationSourceReference);
            this.setupPointcutAdvisor(CacheRemoveEntryInterceptor.class, element, parserContext, elementSource, cacheOperationSourceReference);
            this.setupPointcutAdvisor(CacheRemoveAllInterceptor.class, element, parserContext, elementSource, cacheOperationSourceReference);
            return registry.getBeanDefinition(JCACHE_CACHE_OPERATION_SOURCE_BEAN_NAME);
        }
        return null;
    }

    protected RuntimeBeanReference setupCacheOperationSource(Element element, ParserContext parserContext, Object elementSource) {
        RootBeanDefinition cacheAttributeSource = new RootBeanDefinition(CacheContextSourceImpl.class);
        cacheAttributeSource.setSource(elementSource);
        cacheAttributeSource.setRole(2);
        RootBeanDefinition defaultCacheResolverFactory = new RootBeanDefinition(DefaultCacheResolverFactory.class);
        cacheAttributeSource.setSource(elementSource);
        cacheAttributeSource.setRole(2);
        String cacheManagerName = element.getAttribute(XSD_ATTR_CACHE_MANAGER);
        if (StringUtils.hasText((String)cacheManagerName)) {
            RuntimeBeanReference cacheManagerReference = new RuntimeBeanReference(cacheManagerName);
            ConstructorArgumentValues constructorArgumentValues = new ConstructorArgumentValues();
            constructorArgumentValues.addIndexedArgumentValue(0, (Object)cacheManagerReference);
            cacheAttributeSource.setConstructorArgumentValues(constructorArgumentValues);
        }
        RootBeanDefinition defaultCacheKeyGenerator = new RootBeanDefinition(DefaultCacheKeyGenerator.class);
        cacheAttributeSource.setSource(elementSource);
        cacheAttributeSource.setRole(2);
        MutablePropertyValues propertyValues = cacheAttributeSource.getPropertyValues();
        propertyValues.addPropertyValue("defaultCacheKeyGenerator", (Object)defaultCacheKeyGenerator);
        propertyValues.addPropertyValue("defaultCacheResolverFactory", (Object)defaultCacheResolverFactory);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        registry.registerBeanDefinition(JCACHE_CACHE_OPERATION_SOURCE_BEAN_NAME, (BeanDefinition)cacheAttributeSource);
        return new RuntimeBeanReference(JCACHE_CACHE_OPERATION_SOURCE_BEAN_NAME);
    }

    protected RuntimeBeanReference setupPointcut(ParserContext parserContext, Object elementSource, RuntimeBeanReference cacheOperationSourceRuntimeReference, RuntimeBeanReference cacheInterceptorSourceRuntimeReference) {
        RootBeanDefinition pointcut = new RootBeanDefinition(CacheStaticMethodMatcherPointcut.class);
        pointcut.setSource(elementSource);
        pointcut.setRole(2);
        ConstructorArgumentValues constructorArgumentValues = new ConstructorArgumentValues();
        constructorArgumentValues.addIndexedArgumentValue(0, (Object)cacheOperationSourceRuntimeReference);
        constructorArgumentValues.addIndexedArgumentValue(1, (Object)cacheInterceptorSourceRuntimeReference);
        pointcut.setConstructorArgumentValues(constructorArgumentValues);
        String pointcutBeanName = pointcut.getBeanClassName() + "_" + cacheInterceptorSourceRuntimeReference.getBeanName();
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        registry.registerBeanDefinition(pointcutBeanName, (BeanDefinition)pointcut);
        return new RuntimeBeanReference(pointcutBeanName);
    }

    protected RuntimeBeanReference setupInterceptor(Class<? extends AbstractCacheInterceptor<?>> interceptorClass, ParserContext parserContext, Object elementSource, RuntimeBeanReference cacheOperationSourceRuntimeReference) {
        RootBeanDefinition interceptor = new RootBeanDefinition(interceptorClass);
        interceptor.setSource(elementSource);
        interceptor.setRole(2);
        ConstructorArgumentValues constructorArgumentValues = new ConstructorArgumentValues();
        constructorArgumentValues.addIndexedArgumentValue(0, (Object)cacheOperationSourceRuntimeReference);
        interceptor.setConstructorArgumentValues(constructorArgumentValues);
        XmlReaderContext readerContext = parserContext.getReaderContext();
        String interceptorBeanName = readerContext.registerWithGeneratedName((BeanDefinition)interceptor);
        return new RuntimeBeanReference(interceptorBeanName);
    }

    protected void setupPointcutAdvisor(Class<? extends AbstractCacheInterceptor<?>> interceptorClass, Element element, ParserContext parserContext, Object elementSource, RuntimeBeanReference cacheOperationSourceReference) {
        RuntimeBeanReference interceptorReference = this.setupInterceptor(interceptorClass, parserContext, elementSource, cacheOperationSourceReference);
        RuntimeBeanReference pointcutReference = this.setupPointcut(parserContext, elementSource, cacheOperationSourceReference, interceptorReference);
        RootBeanDefinition pointcutAdvisor = new RootBeanDefinition(DefaultBeanFactoryPointcutAdvisor.class);
        pointcutAdvisor.setSource(elementSource);
        pointcutAdvisor.setRole(2);
        MutablePropertyValues propertyValues = pointcutAdvisor.getPropertyValues();
        propertyValues.addPropertyValue("adviceBeanName", (Object)interceptorReference.getBeanName());
        propertyValues.addPropertyValue("pointcut", (Object)pointcutReference);
        if (element.hasAttribute("order")) {
            propertyValues.addPropertyValue("order", (Object)element.getAttribute("order"));
        }
        XmlReaderContext readerContext = parserContext.getReaderContext();
        readerContext.registerWithGeneratedName((BeanDefinition)pointcutAdvisor);
    }
}

