/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.annotations.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheResolverFactory;
import org.aopalliance.intercept.MethodInvocation;
import org.jsr107.ri.annotations.AbstractCacheLookupUtil;
import org.jsr107.ri.annotations.CacheContextSource;
import org.jsr107.ri.annotations.InternalCacheInvocationContext;
import org.jsr107.ri.annotations.InternalCacheKeyInvocationContext;
import org.jsr107.ri.annotations.StaticCacheInvocationContext;
import org.jsr107.ri.annotations.StaticCacheKeyInvocationContext;
import org.jsr107.ri.annotations.spring.SpringCacheInvocationContextImpl;
import org.jsr107.ri.annotations.spring.SpringCacheKeyInvocationContextImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;

public class CacheContextSourceImpl
extends AbstractCacheLookupUtil<MethodInvocation>
implements CacheContextSource<MethodInvocation>,
BeanFactoryAware {
    private CacheKeyGenerator defaultCacheKeyGenerator;
    private CacheResolverFactory defaultCacheResolverFactory;
    private BeanFactory beanFactory;

    public void setDefaultCacheKeyGenerator(CacheKeyGenerator defaultCacheKeyGenerator) {
        this.defaultCacheKeyGenerator = defaultCacheKeyGenerator;
    }

    public void setDefaultCacheResolverFactory(CacheResolverFactory defaultCacheResolverFactory) {
        this.defaultCacheResolverFactory = defaultCacheResolverFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected InternalCacheKeyInvocationContext<? extends Annotation> createCacheKeyInvocationContextImpl(StaticCacheKeyInvocationContext<? extends Annotation> staticCacheKeyInvocationContext, MethodInvocation invocation) {
        return new SpringCacheKeyInvocationContextImpl<Annotation>(staticCacheKeyInvocationContext, invocation);
    }

    protected InternalCacheInvocationContext<? extends Annotation> createCacheInvocationContextImpl(StaticCacheInvocationContext<? extends Annotation> staticCacheInvocationContext, MethodInvocation invocation) {
        return new SpringCacheInvocationContextImpl<Annotation>(staticCacheInvocationContext, invocation);
    }

    protected Class<?> getTargetClass(MethodInvocation invocation) {
        return invocation.getThis().getClass();
    }

    protected Method getMethod(MethodInvocation invocation) {
        return invocation.getMethod();
    }

    protected <T extends Annotation> T getAnnotation(Class<T> annotationClass, Method method, Class<? extends Object> targetClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        T annotation = (specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod)).getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        if (specificMethod != method) {
            return method.getAnnotation(annotationClass);
        }
        return null;
    }

    protected <T> T getObjectByType(Class<T> type) {
        return (T)this.beanFactory.getBean(type);
    }

    protected CacheKeyGenerator getDefaultCacheKeyGenerator() {
        return this.defaultCacheKeyGenerator;
    }

    protected CacheResolverFactory getDefaultCacheResolverFactory() {
        return this.defaultCacheResolverFactory;
    }
}

