/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.annotations;

public final class ClassFilter {
    private ClassFilter() {
    }

    public static <T> boolean isIncluded(T candidate, Class<? extends T>[] included, Class<? extends T>[] excluded, boolean includeBothEmpty) {
        boolean excludedEmpty;
        if (candidate == null) {
            throw new IllegalArgumentException("candidate can not be null");
        }
        boolean includedEmpty = included == null || included.length == 0;
        boolean bl = excludedEmpty = excluded == null || excluded.length == 0;
        if (includedEmpty && excludedEmpty) {
            return includeBothEmpty;
        }
        boolean matchesInclude = ClassFilter.matches(candidate, included);
        boolean matchesExclude = ClassFilter.matches(candidate, excluded);
        if (includedEmpty) {
            return !matchesExclude;
        }
        if (excludedEmpty) {
            return matchesInclude;
        }
        return matchesInclude && !matchesExclude;
    }

    public static <T> boolean matches(T candidate, Class<? extends T>[] classes) {
        if (classes == null) {
            return false;
        }
        Class<?> candidateClass = candidate.getClass();
        for (Class<T> clazz : classes) {
            if (!clazz.isAssignableFrom(candidateClass)) continue;
            return true;
        }
        return false;
    }
}

