/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.annotations;

import java.lang.annotation.Annotation;
import javax.cache.Cache;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResolver;
import org.jsr107.ri.annotations.AbstractCacheInterceptor;
import org.jsr107.ri.annotations.CacheContextSource;
import org.jsr107.ri.annotations.ClassFilter;
import org.jsr107.ri.annotations.InterceptorType;
import org.jsr107.ri.annotations.InternalCacheInvocationContext;
import org.jsr107.ri.annotations.StaticCacheInvocationContext;

public abstract class AbstractCacheRemoveAllInterceptor<I>
extends AbstractCacheInterceptor<I> {
    public final Object cacheRemoveAll(CacheContextSource<I> cacheContextSource, I invocation) throws Throwable {
        Object result;
        InternalCacheInvocationContext<Annotation> cacheInvocationContext = cacheContextSource.getCacheInvocationContext(invocation);
        Object methodDetails = this.getCacheInvocationContext(cacheInvocationContext, InterceptorType.CACHE_REMOVE_ALL);
        CacheRemoveAll cacheRemoveAllAnnotation = (CacheRemoveAll)methodDetails.getCacheAnnotation();
        boolean afterInvocation = cacheRemoveAllAnnotation.afterInvocation();
        if (!afterInvocation) {
            this.removeAll((InternalCacheInvocationContext<? extends Annotation>)cacheInvocationContext, (StaticCacheInvocationContext<CacheRemoveAll>)methodDetails);
        }
        try {
            result = this.proceed(invocation);
        }
        catch (Throwable t) {
            Class[] noEvictFor;
            Class[] evictFor;
            boolean cache;
            if (afterInvocation && (cache = ClassFilter.isIncluded(t, evictFor = cacheRemoveAllAnnotation.evictFor(), noEvictFor = cacheRemoveAllAnnotation.noEvictFor(), false))) {
                this.removeAll((InternalCacheInvocationContext<? extends Annotation>)cacheInvocationContext, (StaticCacheInvocationContext<CacheRemoveAll>)methodDetails);
            }
            throw t;
        }
        if (afterInvocation) {
            this.removeAll((InternalCacheInvocationContext<? extends Annotation>)cacheInvocationContext, (StaticCacheInvocationContext<CacheRemoveAll>)methodDetails);
        }
        return result;
    }

    protected void removeAll(InternalCacheInvocationContext<? extends Annotation> cacheInvocationContext, StaticCacheInvocationContext<CacheRemoveAll> methodDetails) {
        CacheResolver cacheResolver = methodDetails.getCacheResolver();
        Cache cache = cacheResolver.resolveCache(cacheInvocationContext);
        cache.removeAll();
    }

    protected <T extends StaticCacheInvocationContext<?>> T getCacheInvocationContext(InternalCacheInvocationContext<? extends Annotation> cacheInvocationContext, InterceptorType interceptorType) {
        StaticCacheInvocationContext<? extends Annotation> staticCacheInvocationContext = cacheInvocationContext.getStaticCacheInvocationContext();
        if (staticCacheInvocationContext.getInterceptorType() != interceptorType) {
            throw new IllegalStateException("AroundInvoke method for " + (Object)((Object)interceptorType) + " called but MethodDetails.InterceptorType is " + (Object)((Object)staticCacheInvocationContext.getInterceptorType()));
        }
        return (T)staticCacheInvocationContext;
    }
}

