/*
 * Decompiled with CFR 0.152.
 */
package org.jspringbot.keyword.stats;

import java.util.HashMap;
import java.util.Map;
import org.jspringbot.keyword.stats.StatsInfo;

public class StatsCollectorHelper {
    protected Map<String, StatsInfo> statsInfoMap = new HashMap<String, StatsInfo>();

    public void reset() {
        this.statsInfoMap = new HashMap<String, StatsInfo>();
    }

    public void includeStat(String string) {
        StatsInfo statsInfo = this.statsInfoMap.get(string);
        if (statsInfo == null) {
            statsInfo = new StatsInfo();
            this.statsInfoMap.put(string, statsInfo);
        }
        statsInfo.add();
        this.computePercent();
    }

    public void percentageShouldBe(String string, int expectedPercentage) {
        StatsInfo statsInfo = this.statsInfoMap.get(string);
        if (expectedPercentage != statsInfo.getPercentage()) {
            throw new IllegalStateException(String.format("Expected percentage '%d%%' of '%s' should be equal to actual percentage '%d%%'", expectedPercentage, string, statsInfo.getPercentage()));
        }
    }

    public void percentageShouldBeInRange(String string, int expectedStartPercentage, int expectedEndPercentage) {
        StatsInfo statsInfo = this.statsInfoMap.get(string);
        if (statsInfo.getPercentage() < expectedStartPercentage || statsInfo.getPercentage() > expectedEndPercentage) {
            throw new IllegalStateException(String.format("Expected percentage '%d%%-%d%%' of '%s' should be equal to actual percentage '%d%%'", expectedStartPercentage, expectedEndPercentage, string, statsInfo.getPercentage()));
        }
    }

    private void computePercent() {
        int totalCount = 0;
        for (StatsInfo statsInfo : this.statsInfoMap.values()) {
            totalCount += statsInfo.getCount();
        }
        for (StatsInfo statsInfo : this.statsInfoMap.values()) {
            statsInfo.setTotal(totalCount);
        }
    }
}

