/*
 * Decompiled with CFR 0.152.
 */
package org.jspringbot.keyword.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jspringbot.JSpringBotLogger;

public class MapSetHelper {
    private static final JSpringBotLogger LOGGER = JSpringBotLogger.getLogger(MapSetHelper.class);
    private Map<String, Set<String>> items = new LinkedHashMap<String, Set<String>>();

    public void reset() {
        this.items.clear();
    }

    public boolean add(String key, String value) {
        Set<String> values = this.items.get(key);
        if (values == null) {
            values = new LinkedHashSet<String>();
            this.items.put(key, values);
        }
        return values.add(value);
    }

    public String randomConcat(String key, String delimiter, int size) {
        if (!this.items.containsKey(key)) {
            throw new IllegalArgumentException("No values for key " + key);
        }
        Set<String> values = this.items.get(key);
        if (size > values.size()) {
            LOGGER.info("size reduced to actual item size: from " + size + " to " + values.size(), new Object[0]);
            size = values.size();
        }
        ArrayList<String> shuffled = new ArrayList<String>(values);
        Collections.shuffle(shuffled);
        return StringUtils.join(shuffled.subList(0, size), (String)delimiter);
    }

    public Set<String> getKeys() {
        if (this.items.isEmpty()) {
            throw new IllegalArgumentException("Map is empty");
        }
        return this.items.keySet();
    }

    public String getRandomKey() {
        if (this.items.isEmpty()) {
            throw new IllegalArgumentException("Map is empty");
        }
        ArrayList<String> shuffled = new ArrayList<String>(this.items.keySet());
        Collections.shuffle(shuffled);
        return (String)shuffled.iterator().next();
    }

    public int size(String key) {
        if (!this.items.containsKey(key)) {
            throw new IllegalArgumentException("No values for key " + key);
        }
        return this.items.get(key).size();
    }
}

