/*
 * Decompiled with CFR 0.152.
 */
package org.jspringbot.keyword.date;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.base.BaseDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.jspringbot.keyword.date.DateHelper;
import org.jspringbot.spring.ApplicationContextHolder;
import org.jspringbot.syntax.HighlightRobotLogger;

public class DateUtils {
    public static final HighlightRobotLogger LOG = HighlightRobotLogger.getLogger(DateUtils.class);
    private static final Pattern AMEND_DATE_PATTERN = Pattern.compile("([\\+\\-])([0-9]+)([mdDMyYSshHrR])");

    private static DateHelper getHelper() {
        return (DateHelper)ApplicationContextHolder.get().getBean(DateHelper.class);
    }

    public static java.util.Date toUtilDate(String ... args) {
        if (args != null && args.length > 1) {
            DateUtils.parse(args);
        }
        return DateUtils.getHelper().getUtilDate();
    }

    public static Date toSQLDate(String ... args) {
        if (args != null && args.length > 1) {
            DateUtils.parse(args);
        }
        return DateUtils.getHelper().getSQLDate();
    }

    public static Time toSQLTime(String ... args) {
        if (args != null && args.length > 1) {
            DateUtils.parse(args);
        }
        return DateUtils.getHelper().getSQLTime();
    }

    public static Timestamp toSQLTimestamp(String ... args) {
        if (args != null && args.length > 1) {
            DateUtils.parse(args);
        }
        return DateUtils.getHelper().getSQLTimestamp();
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static String isoParse(String dateString) {
        return DateUtils.getHelper().isoParseDateTime(dateString);
    }

    public static String parse(String ... args) {
        if (args.length == 2) {
            return DateUtils.getHelper().parseDateTime(args[0], args[1]);
        }
        if (args.length == 1) {
            return DateUtils.getHelper().parseDateTime(args[0]);
        }
        throw new IllegalArgumentException("Expected invocation parse(date_str, parsePattern) or parse(date_str).");
    }

    public static String reformat(String date, String parseFormat, String displayFormat) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)parseFormat);
        DateTime current = dateTimeFormatter.parseDateTime(date);
        dateTimeFormatter = DateTimeFormat.forPattern((String)displayFormat);
        return dateTimeFormatter.print((ReadableInstant)current);
    }

    public static String current(String ... args) {
        return DateUtils.format((BaseDateTime)DateUtils.getHelper().getCurrent(), "current", args);
    }

    public static int currentMonth() {
        return DateUtils.getHelper().getCurrent().getMonthOfYear();
    }

    public static int currentDayOfMonth() {
        return DateUtils.getHelper().getCurrent().getDayOfMonth();
    }

    public static int currentYear() {
        return DateUtils.getHelper().getCurrent().getYear();
    }

    public static String midnight(String ... args) {
        return DateUtils.format((BaseDateTime)new DateMidnight(), "midnight", args);
    }

    public static String firstDayOfYear(String ... args) {
        DateMidnight midnight = new DateMidnight();
        midnight = midnight.withMonthOfYear(1);
        midnight = midnight.withDayOfYear(1);
        return DateUtils.format((BaseDateTime)midnight, "midnight", args);
    }

    public static String firstDayOfMonth(String ... args) {
        DateMidnight midnight = new DateMidnight();
        midnight = midnight.withDayOfMonth(1);
        return DateUtils.format((BaseDateTime)midnight, "midnight", args);
    }

    public static String lastDayOfMonth(String ... args) {
        DateMidnight midnight = new DateMidnight();
        midnight = midnight.plusMonths(1);
        midnight = midnight.withDayOfMonth(1);
        midnight = midnight.minusDays(1);
        return DateUtils.format((BaseDateTime)midnight, "midnight", args);
    }

    public static boolean isBeforeNow(String ... args) {
        return DateUtils.getHelper().getCurrent().isBeforeNow();
    }

    public static String now(String ... args) {
        return DateUtils.format((BaseDateTime)new DateTime(), "now", args);
    }

    public static String changeISODateFormat(String dateStr, String pattern) {
        DateTimeFormatter dtf = ISODateTimeFormat.dateTime();
        LocalDateTime parsedDate = dtf.parseLocalDateTime(dateStr);
        String dateWithCustomFormat = parsedDate.toString(DateTimeFormat.forPattern((String)pattern));
        return dateWithCustomFormat;
    }

    public static String formatDate(java.util.Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    private static String format(BaseDateTime dt, String method, String ... args) {
        DateTime dateTime = dt.toDateTime();
        if (args == null || args.length == 0) {
            return DateUtils.format(dateTime);
        }
        Matcher matcher = AMEND_DATE_PATTERN.matcher(args[0]);
        boolean firstArgAmend = false;
        int startIndex = 0;
        while (matcher.find(startIndex)) {
            firstArgAmend = true;
            char operator = matcher.group(1).charAt(0);
            int amount = Integer.parseInt(matcher.group(2));
            char time = matcher.group(3).charAt(0);
            block0 : switch (time) {
                case 'Y': 
                case 'y': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusYears(amount);
                            break;
                        }
                        case '-': {
                            dateTime = dateTime.minusYears(amount);
                        }
                    }
                    break;
                }
                case 'M': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusMonths(amount);
                            break;
                        }
                        case '-': {
                            dateTime = dateTime.minusMonths(amount);
                        }
                    }
                    break;
                }
                case 'R': 
                case 'r': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusDays(DateUtils.random(0, amount));
                            break;
                        }
                        case '-': {
                            dateTime = dateTime.minusDays(DateUtils.random(0, amount));
                        }
                    }
                    break;
                }
                case 'D': 
                case 'd': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusDays(amount);
                            break;
                        }
                        case '-': {
                            dateTime = dateTime.minusDays(amount);
                        }
                    }
                    break;
                }
                case 'H': 
                case 'h': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusHours(amount);
                            break;
                        }
                        case '-': {
                            dateTime = dateTime.minusHours(amount);
                        }
                    }
                    break;
                }
                case 'm': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusMinutes(amount);
                            break;
                        }
                        case '-': {
                            dateTime = dateTime.minusMinutes(amount);
                        }
                    }
                    break;
                }
                case 'S': 
                case 's': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusSeconds(amount);
                            break block0;
                        }
                        case '-': {
                            dateTime = dateTime.minusSeconds(amount);
                        }
                    }
                }
            }
            startIndex = matcher.end();
        }
        if (firstArgAmend && args.length == 1) {
            return DateUtils.format(dateTime);
        }
        if (!firstArgAmend && args.length == 1) {
            return DateUtils.format(dateTime, args[0]);
        }
        if (args.length > 2) {
            return DateUtils.format(dateTime, args[1]);
        }
        throw new IllegalArgumentException(String.format("Expected invocation %s() or %s(format) or %s(amend_date, format) or %s(amend_date).", method, method, method, method));
    }

    public static DateTime amend(BaseDateTime dt, String ... args) {
        DateTime dateTime = dt.toDateTime();
        if (args == null || args.length == 0) {
            return dateTime;
        }
        Matcher matcher = AMEND_DATE_PATTERN.matcher(args[0]);
        boolean firstArgAmend = false;
        int startIndex = 0;
        while (matcher.find(startIndex)) {
            firstArgAmend = true;
            char operator = matcher.group(1).charAt(0);
            int amount = Integer.parseInt(matcher.group(2));
            char time = matcher.group(3).charAt(0);
            block0 : switch (time) {
                case 'Y': 
                case 'y': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusYears(amount);
                            break;
                        }
                        case '-': {
                            dateTime = dateTime.minusYears(amount);
                        }
                    }
                    break;
                }
                case 'M': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusMonths(amount);
                            break;
                        }
                        case '-': {
                            dateTime = dateTime.minusMonths(amount);
                        }
                    }
                    break;
                }
                case 'R': 
                case 'r': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusDays(DateUtils.random(0, amount));
                            break;
                        }
                        case '-': {
                            dateTime = dateTime.minusDays(DateUtils.random(0, amount));
                        }
                    }
                    break;
                }
                case 'D': 
                case 'd': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusDays(amount);
                            break;
                        }
                        case '-': {
                            dateTime = dateTime.minusDays(amount);
                        }
                    }
                    break;
                }
                case 'H': 
                case 'h': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusHours(amount);
                            break;
                        }
                        case '-': {
                            dateTime = dateTime.minusHours(amount);
                        }
                    }
                    break;
                }
                case 'm': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusMinutes(amount);
                            break;
                        }
                        case '-': {
                            dateTime = dateTime.minusMinutes(amount);
                        }
                    }
                    break;
                }
                case 'S': 
                case 's': {
                    switch (operator) {
                        case '+': {
                            dateTime = dateTime.plusSeconds(amount);
                            break block0;
                        }
                        case '-': {
                            dateTime = dateTime.minusSeconds(amount);
                        }
                    }
                }
            }
            startIndex = matcher.end();
        }
        return dateTime;
    }

    private static int random(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    private static String format(DateTime dateTime) {
        return DateUtils.format(dateTime, DateUtils.getHelper().getFormatterPattern());
    }

    private static String format(DateTime dateTime, String formatPattern) {
        DateTimeZone currentTimeZone = DateUtils.getHelper().getCurrentTimeZone();
        LOG.keywordAppender().appendProperty("Print Pattern", (Object)formatPattern).appendProperty("Print Time Zone ID", (Object)currentTimeZone);
        DateTime formatDt = dateTime.withZone(currentTimeZone);
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)formatPattern);
        return dateTimeFormatter.print((ReadableInstant)formatDt);
    }
}

