/*
 * Decompiled with CFR 0.152.
 */
package org.jspringbot.keyword.date;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.base.BaseDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.jspringbot.keyword.date.DateUtils;
import org.jspringbot.keyword.date.util.I18nHelper;
import org.jspringbot.syntax.HighlightRobotLogger;

public class DateHelper {
    public static final HighlightRobotLogger LOG = HighlightRobotLogger.getLogger(DateHelper.class);
    private DateTime current = new DateTime();
    private DateTimeZone currentTimeZone = DateTimeZone.getDefault();
    private String formatterPattern = "yyyy-MM-dd HH:mm:ss zz";

    public void setDateTimeZone(String timeZoneId) {
        LOG.keywordAppender().appendProperty("Time Zone ID", (Object)timeZoneId);
        this.currentTimeZone = DateTimeZone.forID((String)timeZoneId);
    }

    public void setDateTimeFormat(String pattern) {
        LOG.keywordAppender().appendProperty("Pattern", (Object)pattern);
        DateTimeFormat.forPattern((String)pattern);
        this.formatterPattern = pattern;
    }

    public DateTime getCurrent() {
        return this.current;
    }

    public DateTimeZone getCurrentTimeZone() {
        return this.currentTimeZone;
    }

    public String getFormatterPattern() {
        return this.formatterPattern;
    }

    public String parseDateTime(String dateStr) {
        return this.parseDateTime(dateStr, this.formatterPattern);
    }

    public Date getUtilDate() {
        DateTime dt = this.current.withZone(this.currentTimeZone);
        return new Date(dt.getMillis());
    }

    public java.sql.Date getSQLDate() {
        DateTime dt = this.current.withZone(this.currentTimeZone);
        return new java.sql.Date(dt.getMillis());
    }

    public Time getSQLTime() {
        DateTime dt = this.current.withZone(this.currentTimeZone);
        return new Time(dt.getMillis());
    }

    public Timestamp getSQLTimestamp() {
        DateTime dt = this.current.withZone(this.currentTimeZone);
        return new Timestamp(dt.getMillis());
    }

    public DateTime getParseDateTime(String dateStr) {
        return this.getParseDateTime(dateStr, this.formatterPattern);
    }

    public DateTime getParseDateTime(String dateStr, String pattern) {
        LOG.keywordAppender().appendProperty("Date String", (Object)dateStr).appendProperty("Parse Pattern", (Object)pattern);
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)pattern);
        return dateTimeFormatter.parseDateTime(dateStr);
    }

    public String parseDateTime(String dateStr, String pattern) {
        LOG.keywordAppender().appendProperty("Date String", (Object)dateStr).appendProperty("Parse Pattern", (Object)pattern);
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)pattern);
        this.current = dateTimeFormatter.parseDateTime(dateStr);
        return this.formatDateTime();
    }

    public String isoParseDateTime(String dateStr) {
        LOG.keywordAppender().appendProperty("Date String", (Object)dateStr);
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        this.current = fmt.parseDateTime(dateStr);
        return this.formatDateTime();
    }

    public String formatDateTime(String pattern) {
        LOG.keywordAppender().appendProperty("Print Pattern", (Object)this.formatterPattern).appendProperty("Print Time Zone ID", (Object)this.currentTimeZone.getID());
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)pattern);
        DateTime dt = this.current.withZone(this.currentTimeZone);
        String formattedValue = dateTimeFormatter.print((ReadableInstant)dt);
        LOG.keywordAppender().appendProperty("Print Result", (Object)formattedValue);
        return formattedValue;
    }

    public String formatEpochTimeStamp(String epoch, String format, String timeZoneId) {
        LOG.keywordAppender().appendProperty("Epoch Timestamp", (Object)epoch).appendProperty("Date Time Format", (Object)format).appendProperty("Time Zone Id", (Object)timeZoneId);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        Date date = new Date(Long.parseLong(epoch) * 1000L);
        String formattedValue = sdf.format(date);
        LOG.keywordAppender().appendProperty("Formatted Result", (Object)formattedValue);
        return formattedValue;
    }

    public void amendDate(String amend) {
        this.current = DateUtils.amend((BaseDateTime)this.current, amend);
    }

    public String formatDateTime() {
        return this.formatDateTime(this.formatterPattern);
    }

    public void resetDateTime() {
        this.current = new DateTime();
        this.formatDateTime();
    }

    public void plusDays(int days) {
        LOG.keywordAppender().appendProperty("Added Days", (Object)days);
        this.current = this.current.plusDays(days);
        this.formatDateTime();
    }

    public void minusDays(int days) {
        LOG.keywordAppender().appendProperty("Subtract Days", (Object)days);
        this.current = this.current.minusDays(days);
        this.formatDateTime();
    }

    public String compareDates(String format, String dateOne, String dateTwo) {
        String comparisonResult = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            Date date1 = sdf.parse(dateOne);
            Date date2 = sdf.parse(dateTwo);
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(date1);
            cal2.setTime(date2);
            if (cal1.after(cal2)) {
                comparisonResult = "Date1 is after Date2";
            }
            if (cal1.before(cal2)) {
                comparisonResult = "Date1 is before Date2";
            }
            if (cal1.equals(cal2)) {
                comparisonResult = "Date1 is equal to Date2";
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return comparisonResult;
    }

    public String compareLocaleDates(String localeID, String format, String dateOne, String dateTwo) {
        String comparisonResult = null;
        try {
            I18nHelper i18n = new I18nHelper();
            i18n.setLocale(localeID);
            SimpleDateFormat sdf = new SimpleDateFormat(format, i18n.getLocale());
            Date date1 = sdf.parse(dateOne);
            Date date2 = sdf.parse(dateTwo);
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(date1);
            cal2.setTime(date2);
            if (cal1.after(cal2)) {
                comparisonResult = "Date1 is after Date2";
            }
            if (cal1.before(cal2)) {
                comparisonResult = "Date1 is before Date2";
            }
            if (cal1.equals(cal2)) {
                comparisonResult = "Date1 is equal to Date2";
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return comparisonResult;
    }
}

