/*
 * Decompiled with CFR 0.152.
 */
package org.jspringbot.keyword.config;

import java.util.Properties;
import org.jspringbot.keyword.config.ConfigHelper;
import org.jspringbot.syntax.HighlightRobotLogger;

public class ConfigDomainObject {
    public static final HighlightRobotLogger LOG = HighlightRobotLogger.getLogger(ConfigDomainObject.class);
    private Properties properties;
    private String selectedDomain;

    public ConfigDomainObject(String selectedDomain, Properties properties) {
        this.properties = properties;
        this.selectedDomain = selectedDomain;
    }

    public String getDomain() {
        return this.selectedDomain;
    }

    public String get(String code) {
        LOG.keywordAppender().appendProperty("Config Domain", (Object)this.selectedDomain).appendProperty("Config Key", (Object)code);
        if (!this.properties.containsKey(code)) {
            throw new IllegalArgumentException(String.format("No property found for key '%s'", code));
        }
        LOG.keywordAppender().appendProperty("Config String Value", (Object)this.properties.getProperty(code));
        return ConfigHelper.evaluate(this.properties.getProperty(code));
    }

    public Boolean getBoolean(String code) {
        return Boolean.valueOf(this.get(code));
    }

    public Integer getInteger(String code) {
        return Integer.valueOf(this.get(code));
    }

    public Long getLong(String code) {
        return Long.valueOf(this.get(code));
    }

    public Double getDouble(String code) {
        return Double.valueOf(this.get(code));
    }
}

