/*
 * Decompiled with CFR 0.152.
 */
package org.jsonurl.j2se;

import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jsonurl.BigMath;
import org.jsonurl.BigMathProvider;
import org.jsonurl.factory.ValueFactory;
import org.jsonurl.text.NumberBuilder;
import org.jsonurl.text.NumberText;

public interface JavaValueFactory
extends ValueFactory.TransparentBuilder<Object, Object, List<Object>, Map<String, Object>, Boolean, Number, Object, String> {
    public static final Object NULL = new Object();
    public static final Map<String, Object> EMPTY = Collections.emptyMap();
    public static final BigMathFactory BIGMATH32 = new BigMathFactory(MathContext.DECIMAL32, BigMath.BIG_INTEGER32_BOUNDARY_NEG, BigMath.BIG_INTEGER32_BOUNDARY_POS, null);
    public static final BigMathFactory BIGMATH64 = new BigMathFactory(MathContext.DECIMAL64, BigMath.BIG_INTEGER64_BOUNDARY_NEG, BigMath.BIG_INTEGER64_BOUNDARY_POS, null);
    public static final BigMathFactory BIGMATH128 = new BigMathFactory(MathContext.DECIMAL128, "170141183460469231731687303715884105728", "170141183460469231731687303715884105727", null);
    public static final JavaValueFactory PRIMITIVE = new JavaValueFactory(){

        @Override
        public Number getNumber(NumberText text) {
            return NumberBuilder.build((NumberText)text, (boolean)true);
        }
    };
    public static final JavaValueFactory DOUBLE = new JavaValueFactory(){

        @Override
        public Number getNumber(NumberText text) {
            return Double.valueOf(text.toString());
        }
    };

    @Override
    default public Object getEmptyComposite() {
        return EMPTY;
    }

    @Override
    default public Object getNull() {
        return NULL;
    }

    @Override
    default public List<Object> newArrayBuilder() {
        return new LinkedList<Object>();
    }

    @Override
    default public Map<String, Object> newObjectBuilder() {
        return new HashMap<String, Object>(4);
    }

    @Override
    default public List<Object> newArray(List<Object> builder) {
        return new ArrayList<Object>(builder);
    }

    @Override
    default public void add(List<Object> dest, Object obj) {
        dest.add(obj);
    }

    @Override
    default public void put(Map<String, Object> dest, String key, Object value) {
        dest.put(key, value);
    }

    @Override
    default public Boolean getTrue() {
        return Boolean.TRUE;
    }

    @Override
    default public Boolean getFalse() {
        return Boolean.FALSE;
    }

    @Override
    default public String getString(CharSequence text, int start, int stop) {
        return JavaValueFactory.toJavaString(text, start, stop);
    }

    @Override
    default public String getString(String value) {
        return value;
    }

    public static String toJavaString(CharSequence text, int start, int stop) {
        if (text instanceof String) {
            String str = (String)text;
            if (start == 0 && stop == text.length()) {
                return str;
            }
            return str.substring(start, stop);
        }
        return text.subSequence(start, stop).toString();
    }

    public static class BigMathFactory
    extends BigMath
    implements JavaValueFactory,
    ValueFactory.BigMathFactory<Object, Object, List<Object>, List<Object>, Map<String, Object>, Map<String, Object>, Boolean, Number, Object, String> {
        public BigMathFactory(MathContext context, String bigIntegerBoundaryNeg, String bigIntegerBoundaryPos, BigMathProvider.BigIntegerOverflow bigIntegerOverflow) {
            super(context, bigIntegerBoundaryNeg, bigIntegerBoundaryPos, bigIntegerOverflow);
        }

        @Override
        public Number getNumber(NumberText text) {
            return NumberBuilder.build((NumberText)text, (boolean)false, (BigMathProvider)this);
        }
    }
}

