/*
 * Decompiled with CFR 0.152.
 */
package org.jsonurl.factory;

import org.jsonurl.BigMathProvider;
import org.jsonurl.text.NumberText;

public interface ValueFactory<V, C extends V, ABT, A extends C, JBT, J extends C, B extends V, M extends V, N extends V, S extends V> {
    public C getEmptyComposite();

    public A newArray(ABT var1);

    public J newObject(JBT var1);

    public ABT newArrayBuilder();

    public JBT newObjectBuilder();

    public void add(ABT var1, V var2);

    public void put(JBT var1, String var2, V var3);

    public N getNull();

    public B getTrue();

    public B getFalse();

    public S getString(CharSequence var1, int var2, int var3);

    default public S getString(String text) {
        return this.getString(text, 0, text.length());
    }

    public M getNumber(NumberText var1);

    default public B getBoolean(boolean value) {
        return value ? this.getTrue() : this.getFalse();
    }

    default public boolean isEmptyComposite(Object obj) {
        return obj == this.getEmptyComposite();
    }

    default public boolean isNull(Object obj) {
        return obj == null || obj == this.getNull();
    }

    public static interface BigMathFactory<V, C extends V, ABT, A extends C, JBT, J extends C, B extends V, M extends V, N extends V, S extends V>
    extends ValueFactory<V, C, ABT, A, JBT, J, B, M, N, S>,
    BigMathProvider {
    }

    public static interface TransparentBuilder<V, C extends V, A extends C, J extends C, B extends V, M extends V, N extends V, S extends V>
    extends ValueFactory<V, C, A, A, J, J, B, M, N, S> {
        @Override
        default public A newArray(A builder) {
            return builder;
        }

        @Override
        default public J newObject(J builder) {
            return builder;
        }
    }
}

