/*
 * Decompiled with CFR 0.152.
 */
package org.jsonurl.factory;

import java.util.Set;
import org.jsonurl.JsonUrlLimits;
import org.jsonurl.JsonUrlOptionable;
import org.jsonurl.factory.MissingValueProvider;
import org.jsonurl.factory.ValueFactory;
import org.jsonurl.stream.CharIterator;
import org.jsonurl.stream.JsonUrlCharSequence;
import org.jsonurl.stream.JsonUrlIterator;

public interface Parser<V, C extends V, ABT, A extends C, JBT, J extends C, B extends V, M extends V, N extends V, S extends V>
extends JsonUrlOptionable {
    public JsonUrlLimits limits();

    public ValueFactory<V, C, ABT, A, JBT, J, B, M, N, S> factory();

    default public J parseObject(CharSequence text) {
        return this.parseObject(text, 0, text.length(), null);
    }

    default public J parseObject(CharSequence text, int off, int length) {
        return this.parseObject(text, off, length, null);
    }

    default public J parseObject(CharSequence text, JBT impliedObject) {
        return this.parseObject(text, 0, text.length(), impliedObject, null);
    }

    default public J parseObject(CharSequence text, JBT impliedObject, MissingValueProvider<V> mvp) {
        return this.parseObject(text, 0, text.length(), impliedObject, mvp);
    }

    default public J parseObject(CharSequence text, int off, int length, JBT impliedObject) {
        return this.parseObject(text, off, length, impliedObject, null);
    }

    default public J parseObject(CharSequence text, int off, int length, JBT impliedObject, MissingValueProvider<V> mvp) {
        JsonUrlCharSequence chars = new JsonUrlCharSequence(null, text, off, length, JsonUrlLimits.getMaxParseChars((JsonUrlLimits)this.limits()));
        return this.parseObject((CharIterator)chars, impliedObject, mvp);
    }

    default public J parseObject(CharIterator iter, JBT impliedObject, MissingValueProvider<V> mvp) {
        return this.parseObject(JsonUrlIterator.newInstance((CharIterator)iter, (JsonUrlLimits)this.limits(), (Set)this.options()), impliedObject, mvp);
    }

    public J parseObject(JsonUrlIterator var1, JBT var2, MissingValueProvider<V> var3);

    default public A parseArray(CharSequence text) {
        return this.parseArray(text, 0, text.length(), null);
    }

    default public A parseArray(CharSequence text, int off, int length) {
        return this.parseArray(text, off, length, null);
    }

    default public A parseArray(CharSequence text, ABT impliedArray) {
        return this.parseArray(text, 0, text.length(), impliedArray, null);
    }

    default public A parseArray(CharSequence text, ABT impliedArray, MissingValueProvider<V> mvp) {
        return this.parseArray(text, 0, text.length(), impliedArray, mvp);
    }

    default public A parseArray(CharSequence text, int off, int length, ABT impliedArray) {
        return this.parseArray(text, off, length, impliedArray, null);
    }

    default public A parseArray(CharSequence text, int off, int length, ABT impliedArray, MissingValueProvider<V> mvp) {
        JsonUrlCharSequence chars = new JsonUrlCharSequence(null, text, off, length, JsonUrlLimits.getMaxParseChars((JsonUrlLimits)this.limits()));
        return this.parseArray((CharIterator)chars, impliedArray, mvp);
    }

    default public A parseArray(CharIterator iter, ABT impliedArray, MissingValueProvider<V> mvp) {
        return this.parseArray(JsonUrlIterator.newInstance((CharIterator)iter, (JsonUrlLimits)this.limits(), (Set)this.options()), impliedArray, mvp);
    }

    public A parseArray(JsonUrlIterator var1, ABT var2, MissingValueProvider<V> var3);

    default public V parse(CharSequence text) {
        return this.parse(text, 0, text.length());
    }

    default public V parse(CharSequence text, int off, int length) {
        JsonUrlCharSequence chars = new JsonUrlCharSequence(null, text, off, length, JsonUrlLimits.getMaxParseChars((JsonUrlLimits)this.limits()));
        return this.parse((CharIterator)chars);
    }

    default public V parse(CharIterator iter) {
        return this.parse(JsonUrlIterator.newInstance((CharIterator)iter, (JsonUrlLimits)this.limits(), (Set)this.options()));
    }

    public V parse(JsonUrlIterator var1);

    public static interface TransparentBuilder<V, C extends V, A extends C, J extends C, B extends V, M extends V, N extends V, S extends V>
    extends Parser<V, C, A, A, J, J, B, M, N, S> {
    }
}

