/*
 * Decompiled with CFR 0.152.
 */
package org.jsonurl.factory;

import java.util.Deque;
import java.util.LinkedList;
import org.jsonurl.CompositeType;
import org.jsonurl.ExceptionProvider;
import org.jsonurl.SyntaxException;
import org.jsonurl.factory.MissingValueProvider;
import org.jsonurl.factory.ValueFactory;
import org.jsonurl.text.NumberText;

class ParseResult<V, C extends V, ABT, A extends C, JBT, J extends C, B extends V, M extends V, N extends V, S extends V> {
    private final Deque<String> keyStack = new LinkedList<String>();
    private final Deque<V> valueStack = new LinkedList<V>();
    private final Deque<CompositeBuilder> builderStack = new LinkedList<CompositeBuilder>();
    private final ValueFactory<V, C, ABT, A, JBT, J, B, M, N, S> factory;
    private final MissingValueProvider<V> missingValueProvider;
    private final CompositeType impliedComposite;

    public ParseResult(ValueFactory<V, C, ABT, A, JBT, J, B, M, N, S> factory, ABT impliedArray, JBT impliedObject, MissingValueProvider<V> missingValueProvider) {
        this.factory = factory;
        MissingValueProvider<Object> missingValueProvider2 = this.missingValueProvider = missingValueProvider == null ? this::defaultMissingValueProvier : missingValueProvider;
        if (impliedArray != null) {
            this.builderStack.push(new ArrayBuilder(impliedArray));
            this.impliedComposite = CompositeType.ARRAY;
        } else if (impliedObject != null) {
            this.builderStack.push(new ObjectBuilder(impliedObject));
            this.impliedComposite = CompositeType.OBJECT;
        } else {
            this.impliedComposite = null;
        }
    }

    public void beginArray() {
        this.builderStack.push(new ArrayBuilder(this.factory.newArrayBuilder()));
    }

    public void endArray() {
        this.endComposite();
    }

    public void beginObject() {
        this.builderStack.push(new ObjectBuilder(this.factory.newObjectBuilder()));
    }

    public void endObject() {
        this.endComposite();
    }

    public void addEmptyComposite() {
        this.valueStack.push(this.factory.getEmptyComposite());
        this.addValue();
    }

    public void addEmptyLiteral() {
        this.valueStack.push(this.factory.getString(""));
        this.addValue();
    }

    public void addTrue() {
        this.valueStack.push(this.factory.getTrue());
        this.addValue();
    }

    public void addFalse() {
        this.valueStack.push(this.factory.getFalse());
        this.addValue();
    }

    public void addNull() {
        this.valueStack.push(this.factory.getNull());
        this.addValue();
    }

    public void addString(String text) {
        this.valueStack.push(this.factory.getString(text));
        this.addValue();
    }

    public void addNumber(NumberText text) {
        this.valueStack.push(this.factory.getNumber(text));
        this.addValue();
    }

    public void addObjectKey(String text) {
        this.keyStack.push(text);
    }

    public void addMissingValue(ExceptionProvider exp) {
        this.valueStack.push(this.missingValueProvider.getValue(this.keyStack.peek(), exp));
        this.addValue();
    }

    public V getResult() {
        if (this.impliedComposite == CompositeType.ARRAY) {
            this.endArray();
        } else if (this.impliedComposite == CompositeType.OBJECT) {
            this.endObject();
        }
        return this.valueStack.peek();
    }

    private V defaultMissingValueProvier(String key, ExceptionProvider exp) {
        throw exp.newSyntaxException(SyntaxException.Message.MSG_EXPECT_OBJECT_VALUE, String.format("%s: %s", SyntaxException.Message.MSG_EXPECT_OBJECT_VALUE, key));
    }

    private void endComposite() {
        CompositeBuilder builder = this.builderStack.pop();
        builder.build();
        this.addValue();
    }

    private void addValue() {
        CompositeBuilder builder = this.builderStack.peek();
        if (builder != null) {
            builder.addValue();
        }
    }

    private final class ArrayBuilder
    implements CompositeBuilder {
        private final ABT builder;

        ArrayBuilder(ABT builder) {
            this.builder = builder;
        }

        @Override
        public void addValue() {
            ParseResult.this.factory.add(this.builder, ParseResult.this.valueStack.pop());
        }

        @Override
        public void build() {
            ParseResult.this.valueStack.push(ParseResult.this.factory.newArray(this.builder));
        }
    }

    private final class ObjectBuilder
    implements CompositeBuilder {
        private final JBT builder;

        ObjectBuilder(JBT builder) {
            this.builder = builder;
        }

        @Override
        public void addValue() {
            Object topval = ParseResult.this.valueStack.pop();
            String key = (String)ParseResult.this.keyStack.pop();
            ParseResult.this.factory.put(this.builder, key, topval);
        }

        @Override
        public void build() {
            ParseResult.this.valueStack.push(ParseResult.this.factory.newObject(this.builder));
        }
    }

    private static interface CompositeBuilder {
        public void addValue();

        public void build();
    }
}

