/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeConversionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldTypeConversionUtils.class);
    public static final String INT = "(int)";
    public static final String LONG = "(long)";
    public static final String FLOAT = "(float)";
    public static final String BOOLEAN = "(boolean)";
    public static final String DECIMAL = "(decimal)";
    public static List<String> fieldTypes = Arrays.asList("(int)", "(float)", "(boolean)", "(decimal)", "(long)");
    static Function<String, Integer> integerFunction = input -> Integer.valueOf(input.substring(INT.length()));
    static Function<String, Long> longFunction = input -> Long.valueOf(input.substring(LONG.length()));
    static Function<String, Float> floatFunction = input -> Float.valueOf(input.substring(FLOAT.length()));
    static Function<String, Float> decimalFunction = input -> Float.valueOf(input.substring(FLOAT.length()));
    static Function<String, Boolean> booleanFUnction = input -> Boolean.valueOf(input.substring(BOOLEAN.length()));
    static Map<String, Function> typeMap = new HashMap<String, Function>(){
        {
            this.put(FieldTypeConversionUtils.INT, integerFunction);
            this.put(FieldTypeConversionUtils.LONG, longFunction);
            this.put(FieldTypeConversionUtils.FLOAT, floatFunction);
            this.put(FieldTypeConversionUtils.DECIMAL, decimalFunction);
            this.put(FieldTypeConversionUtils.BOOLEAN, booleanFUnction);
        }
    };

    public static void deepTypeCast(Map<String, Object> map) {
        map.entrySet().stream().forEach(entry -> {
            Object value = entry.getValue();
            if (value instanceof Map) {
                FieldTypeConversionUtils.deepTypeCast((Map)value);
            } else if (value instanceof ArrayList) {
                for (int index = 0; index < ((ArrayList)value).size(); ++index) {
                    Object thisItemValue = ((ArrayList)value).get(index);
                    if (thisItemValue instanceof Map) {
                        FieldTypeConversionUtils.deepTypeCast((Map)thisItemValue);
                        continue;
                    }
                    FieldTypeConversionUtils.replacePrimitiveValues((ArrayList)value, index, thisItemValue);
                }
            } else {
                LOGGER.debug("Leaf node found = {}, checking for type value...", value);
                FieldTypeConversionUtils.replaceNodeValue(entry, value);
            }
        });
    }

    private static void replaceNodeValue(Map.Entry<String, Object> entry, Object thisItem) {
        try {
            if (thisItem != null) {
                fieldTypes.stream().forEach(currentType -> {
                    if (thisItem.toString().startsWith((String)currentType)) {
                        entry.setValue(typeMap.get(currentType).apply(thisItem.toString()));
                    }
                });
            }
        }
        catch (Exception exx) {
            String errorMsg = "Can not convert '" + entry.getValue() + "'.";
            LOGGER.error("{} with exception details: {}", (Object)errorMsg, (Object)exx);
            throw new RuntimeException(errorMsg + exx);
        }
    }

    private static void replacePrimitiveValues(ArrayList<Object> valueList, Integer index, Object thisItem) {
        try {
            if (thisItem != null) {
                fieldTypes.stream().forEach(currentType -> {
                    if (thisItem.toString().startsWith((String)currentType)) {
                        valueList.set(index, typeMap.get(currentType).apply(thisItem.toString()));
                    }
                });
            }
        }
        catch (Exception exx) {
            String errorMsg = "Can not convert '" + thisItem + "'.";
            LOGGER.error(errorMsg + "\nException Details:" + exx);
            throw new RuntimeException(errorMsg + exx);
        }
    }
}

