/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.logbuilder;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeReportStepBuilder;
import org.jsmart.zerocode.core.domain.reports.ZeroCodeReportStep;
import org.jsmart.zerocode.core.logbuilder.RequestLogBuilder;
import org.jsmart.zerocode.core.logbuilder.ResponseLogBuilder;
import org.jsmart.zerocode.core.logbuilder.ScenarioLogBuilder;
import org.jsmart.zerocode.core.utils.TokenUtils;
import org.slf4j.Logger;

public class ZerocodeCorrelationshipLogger {
    private static final String DISPLAY_DEMARCATION_ = "\n--------- TEST-STEP-CORRELATION-ID: %s ---------";
    private Logger logger;
    private String correlationId;
    private RequestLogBuilder requestLogBuilder = new RequestLogBuilder();
    private ResponseLogBuilder responseLogBuilder = new ResponseLogBuilder();
    private ScenarioLogBuilder scenarioLogBuilder = new ScenarioLogBuilder();
    private Integer stepLoop;
    private Boolean result;
    private Double responseDelay;
    private List<ZeroCodeReportStep> steps = Collections.synchronizedList(new ArrayList());

    public ZerocodeCorrelationshipLogger step(ZeroCodeReportStep step) {
        this.steps.add(step);
        return this;
    }

    public ZerocodeCorrelationshipLogger(Logger logger) {
        this.logger = logger;
    }

    public static ZerocodeCorrelationshipLogger newInstance(Logger logger) {
        return new ZerocodeCorrelationshipLogger(logger);
    }

    public RequestLogBuilder aRequestBuilder() {
        return this.requestLogBuilder;
    }

    public ZerocodeCorrelationshipLogger assertion(String assertionJson) {
        this.responseLogBuilder.assertionSection(assertionJson);
        return this;
    }

    public ZerocodeCorrelationshipLogger customLog(String customLog) {
        this.responseLogBuilder.customLog(customLog);
        return this;
    }

    public ZerocodeCorrelationshipLogger stepLoop(Integer stepLoop) {
        this.stepLoop = stepLoop;
        return this;
    }

    public ZerocodeCorrelationshipLogger stepOutcome(Boolean result) {
        this.result = result;
        return this;
    }

    public ZeroCodeReportStep buildReportSingleStep() {
        this.result = this.result != null ? this.result : false;
        ZeroCodeReportStepBuilder zeroCodeReportStep = ZeroCodeReportStepBuilder.newInstance().loop(this.stepLoop).name(this.requestLogBuilder.getStepName()).correlationId(this.getCorrelationId()).result(this.result == true ? "PASSED" : "FAILED").url(this.requestLogBuilder.getUrl()).operation(this.requestLogBuilder.getMethod()).assertions(this.responseLogBuilder.getAssertion()).requestTimeStamp(this.requestLogBuilder.getRequestTimeStamp()).responseTimeStamp(this.responseLogBuilder.responseTimeStamp).responseDelay(this.responseDelay).id(this.requestLogBuilder.getId());
        if (this.result.booleanValue()) {
            zeroCodeReportStep.result("PASSED");
        } else {
            zeroCodeReportStep.response(this.responseLogBuilder.getResponse());
            zeroCodeReportStep.request(this.requestLogBuilder.getRequest());
        }
        if (null != this.responseLogBuilder.customLog) {
            zeroCodeReportStep.customLog(this.responseLogBuilder.customLog);
        }
        return zeroCodeReportStep.build();
    }

    public ResponseLogBuilder aResponseBuilder() {
        return this.responseLogBuilder;
    }

    public ScenarioLogBuilder aScenarioBuilder() {
        return this.scenarioLogBuilder;
    }

    public void buildResponseDelay() {
        this.responseDelay = ZerocodeCorrelationshipLogger.durationMilliSecBetween(this.requestLogBuilder.getRequestTimeStamp(), this.responseLogBuilder.getResponseTimeStamp());
    }

    public static double durationMilliSecBetween(LocalDateTime requestTimeStamp, LocalDateTime responseTimeStamp) {
        Duration dur = Duration.between(requestTimeStamp, responseTimeStamp != null ? responseTimeStamp : LocalDateTime.now());
        return dur.toMillis();
    }

    public String createRelationshipId() {
        this.correlationId = ZerocodeCorrelationshipLogger.getRelationshipUniqueId();
        return String.format(DISPLAY_DEMARCATION_, this.correlationId);
    }

    public static String getRelationshipUniqueId() {
        return UUID.randomUUID().toString();
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void print() {
        this.buildResponseDelay();
        String customLog = this.responseLogBuilder.getCustomLog();
        String assertionsWithMaskRemoved = TokenUtils.getMasksReplaced(this.responseLogBuilder.getAssertion());
        this.logger.warn(String.format("%s %s \n*Response delay:%s milli-secs \n%s \n%s \n-done-\n", this.requestLogBuilder.toString(), this.responseLogBuilder.toString(), this.responseDelay, "---------> Expected Response: <----------\n" + assertionsWithMaskRemoved, customLog == null ? "" : "---------> Custom Log: <----------\n" + customLog));
    }
}

