/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.validators;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.jsmart.zerocode.core.di.provider.JsonPathJacksonProvider;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;
import org.jsmart.zerocode.core.domain.Step;
import org.jsmart.zerocode.core.domain.Validator;
import org.jsmart.zerocode.core.engine.assertion.FieldAssertionMatcher;
import org.jsmart.zerocode.core.engine.assertion.JsonAsserter;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeAssertionsProcessor;
import org.jsmart.zerocode.core.engine.validators.ZeroCodeValidator;
import org.jsmart.zerocode.core.utils.HelperJsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeValidatorImpl
implements ZeroCodeValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeValidatorImpl.class);
    private final ZeroCodeAssertionsProcessor zeroCodeAssertionsProcessor;
    private final ObjectMapper mapper;

    @Inject
    public ZeroCodeValidatorImpl(ZeroCodeAssertionsProcessor zeroCodeAssertionsProcessor) {
        this.zeroCodeAssertionsProcessor = zeroCodeAssertionsProcessor;
        this.mapper = new ObjectMapperProvider().get();
        Configuration.setDefaults((Configuration.Defaults)new JsonPathJacksonProvider().get());
    }

    @Override
    public List<FieldAssertionMatcher> validateFlat(Step thisStep, String actualResult, String resolvedScenarioState) {
        LOGGER.debug("Comparing results via flat validators");
        ArrayList<FieldAssertionMatcher> failureResults = new ArrayList<FieldAssertionMatcher>();
        List<Validator> validators = thisStep.getValidators();
        for (Validator validator : validators) {
            String actualString;
            String jsonPath = validator.getField();
            String transformed = this.zeroCodeAssertionsProcessor.resolveStringJson(jsonPath, resolvedScenarioState);
            JsonNode expectedValue = validator.getValue();
            Object actualValue = JsonPath.read((String)actualResult, (String)transformed, (Predicate[])new Predicate[0]);
            try {
                actualString = this.mapper.writeValueAsString(actualValue);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            List<JsonAsserter> asserters = this.zeroCodeAssertionsProcessor.createJsonAsserters(expectedValue.toString());
            failureResults.addAll(this.zeroCodeAssertionsProcessor.assertAllAndReturnFailed(asserters, actualString));
        }
        return failureResults;
    }

    @Override
    public List<FieldAssertionMatcher> validateStrict(String expectedResult, String actualResult) {
        LOGGER.debug("Comparing results via STRICT matchers");
        return HelperJsonUtils.strictComparePayload(expectedResult, actualResult);
    }

    @Override
    public List<FieldAssertionMatcher> validateLenient(String expectedResult, String actualResult) {
        LOGGER.debug("Comparing results via LENIENT matchers");
        List<JsonAsserter> asserters = this.zeroCodeAssertionsProcessor.createJsonAsserters(expectedResult);
        return this.zeroCodeAssertionsProcessor.assertAllAndReturnFailed(asserters, actualResult);
    }
}

