/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.assertion.field;

import org.jsmart.zerocode.core.engine.assertion.FieldAssertionMatcher;
import org.jsmart.zerocode.core.engine.assertion.JsonAsserter;

public class FieldContainsStringIgnoreCaseAsserter
implements JsonAsserter {
    private final String path;
    private final String expected;

    public FieldContainsStringIgnoreCaseAsserter(String path, String expected) {
        this.path = path;
        this.expected = expected;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Object getExpected() {
        return this.expected;
    }

    @Override
    public FieldAssertionMatcher actualEqualsToExpected(Object result) {
        boolean areEqual;
        if (result instanceof String && this.expected instanceof String) {
            String s1 = (String)result;
            String s2 = this.expected;
            areEqual = s1.toUpperCase().contains(s2.toUpperCase());
        } else {
            areEqual = false;
        }
        return areEqual ? FieldAssertionMatcher.aMatchingMessage() : FieldAssertionMatcher.aNotMatchingMessage(this.path, "containing sub-string with ignoring case:" + this.expected, result);
    }
}

