/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.domain.builders;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;
import org.jsmart.zerocode.core.domain.reports.ZeroCodeExecResult;
import org.jsmart.zerocode.core.domain.reports.ZeroCodeReport;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeIoWriteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeIoWriteBuilder.class);
    public static final int REPORT_WRITING_THREAD_POOL = 5;
    private LocalDateTime timeStamp;
    private List<ZeroCodeExecResult> results = Collections.synchronizedList(new ArrayList());
    private ZeroCodeReport built;
    private ExecutorService executorService = Executors.newFixedThreadPool(5);

    public static ZeroCodeIoWriteBuilder newInstance() {
        return new ZeroCodeIoWriteBuilder();
    }

    public ZeroCodeReport build() {
        ZeroCodeReport built;
        this.built = built = new ZeroCodeReport(this.timeStamp, this.results);
        return built;
    }

    public ZeroCodeIoWriteBuilder timeStamp(LocalDateTime timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    public ZeroCodeIoWriteBuilder results(List<ZeroCodeExecResult> results) {
        this.results = results;
        return this;
    }

    public ZeroCodeIoWriteBuilder result(ZeroCodeExecResult result) {
        this.results.add(result);
        return this;
    }

    public synchronized void printToFile(String fileName) {
        try {
            this.build();
            ObjectMapper mapper = new ObjectMapperProvider().get();
            fileName = SmartUtils.sanitizeReportFileName(fileName);
            File file = new File("target/zerocode-test-reports/" + fileName);
            file.getParentFile().mkdirs();
            mapper.writeValue(file, (Object)this.built);
            this.delay(100L);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            LOGGER.warn("### Report Generation Problem: There was a problem during JSON parsing. Details: " + (Object)((Object)e));
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.warn("### Report Generation Problem: There was a problem during writing the report. Details: " + e);
        }
    }

    private void delay(long miliSec) {
        try {
            Thread.sleep(miliSec);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Error providing delay");
        }
    }

    public void printToFileAsync(String fileName) {
        this.build();
        ObjectMapper mapper = new ObjectMapperProvider().get();
        LOGGER.debug("executorService(hashCode)>>" + this.executorService.hashCode());
        this.executorService.execute(() -> {
            LOGGER.debug("Writing to file async - " + fileName);
            File file = new File("target/zerocode-test-reports/" + fileName);
            file.getParentFile().mkdirs();
            try {
                mapper.writeValue(file, (Object)this.built);
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.warn("### Report Generation Problem: There was a problem during writing the report. Details: " + e);
            }
        });
        this.shutDownExecutorGraceFully();
    }

    private void shutDownExecutorGraceFully() {
        this.executorService.shutdown();
        while (!this.executorService.isTerminated()) {
        }
        LOGGER.debug("Pass-Fail JSON report written target -done. Finished all threads");
    }
}

