/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.jupiter.listener;

import java.time.LocalDateTime;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeExecReportBuilder;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeIoWriteBuilder;
import org.jsmart.zerocode.core.logbuilder.ZerocodeCorrelationshipLogger;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeTestReportJupiterListener
implements TestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeTestReportJupiterListener.class);
    private final Class<?> testClass;
    private final String testMethod;
    private String testDescription;
    private ZerocodeCorrelationshipLogger corrLogger;
    private String logPrefixRelationshipId;
    private boolean passed = true;

    public ZeroCodeTestReportJupiterListener(Class<?> testClass, String testMethod) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.testDescription = testClass + "#" + testMethod;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.logPrefixRelationshipId = this.prepareRequestReport(this.testDescription);
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.prepareResponseReport(this.logPrefixRelationshipId);
        this.buildReportAndPrintToFile(this.testDescription);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testExecutionResult.getStatus().equals((Object)TestExecutionResult.Status.FAILED)) {
            this.passed = false;
        }
    }

    private String prepareRequestReport(String description) {
        this.corrLogger = ZerocodeCorrelationshipLogger.newInstance((Logger)LOGGER);
        this.corrLogger.stepLoop(Integer.valueOf(0));
        String logPrefixRelationshipId = this.corrLogger.createRelationshipId();
        LocalDateTime timeNow = LocalDateTime.now();
        this.corrLogger.aRequestBuilder().stepLoop(Integer.valueOf(0)).relationshipId(logPrefixRelationshipId).requestTimeStamp(timeNow).step(this.testMethod);
        LOGGER.info("JUnit5 *requestTimeStamp:{}, \nJUnit Request:{}", (Object)timeNow, (Object)logPrefixRelationshipId);
        return logPrefixRelationshipId;
    }

    private void prepareResponseReport(String logPrefixRelationshipId) {
        LocalDateTime timeNow = LocalDateTime.now();
        LOGGER.info("JUnit5 *responseTimeStamp:{}, \nJUnit Response:{}", (Object)timeNow, (Object)logPrefixRelationshipId);
        this.corrLogger.aResponseBuilder().relationshipId(logPrefixRelationshipId).responseTimeStamp(timeNow);
        this.corrLogger.stepOutcome(Boolean.valueOf(this.passed));
        this.corrLogger.buildResponseDelay();
    }

    private void buildReportAndPrintToFile(String description) {
        ZeroCodeExecReportBuilder reportResultBuilder = ZeroCodeExecReportBuilder.newInstance().loop(Integer.valueOf(0)).scenarioName(this.testClass.getName());
        reportResultBuilder.step(this.corrLogger.buildReportSingleStep());
        ZeroCodeIoWriteBuilder reportBuilder = ZeroCodeIoWriteBuilder.newInstance().timeStamp(LocalDateTime.now());
        reportBuilder.result(reportResultBuilder.build());
        reportBuilder.printToFile(description + this.corrLogger.getCorrelationId() + ".json");
    }
}

