/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.classpath.ClassPath;
import com.google.classpath.ClassPathFactory;
import com.google.classpath.RegExpResourceFilter;
import com.google.classpath.ResourceFilter;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jsmart.zerocode.core.di.ObjectMapperProvider;
import org.jsmart.zerocode.core.domain.ScenarioSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SmartUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartUtils.class);
    @Inject
    private ObjectMapper mapper;

    public <T> String getItRight() throws IOException {
        String jsonAsString = this.mapper.toString();
        return jsonAsString;
    }

    public <T> String getJsonDocumentAsString(String fileName) throws IOException {
        String jsonAsString = Resources.toString((URL)this.getClass().getClassLoader().getResource(fileName), (Charset)StandardCharsets.UTF_8);
        return jsonAsString;
    }

    public static String readJsonAsString(String jsonFileName) throws IOException {
        return Resources.toString((URL)Resources.getResource((String)jsonFileName), (Charset)Charset.defaultCharset());
    }

    public Map<String, Object> readJsonStringAsMap(String json) throws IOException {
        HashMap<String, Object> map = new HashMap();
        map = (Map)this.mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return map;
    }

    public static List<String> getAllEndPointFiles(String packageName) {
        ClassPathFactory factory = new ClassPathFactory();
        ClassPath jvmClassPath = factory.createFromJVM();
        String[] allSimulationFiles = jvmClassPath.findResources(packageName, (ResourceFilter)new RegExpResourceFilter(".*", ".*\\.json$"));
        if (null == allSimulationFiles || allSimulationFiles.length == 0) {
            throw new RuntimeException("OverSmartTryingToNothingException: Check the (" + packageName + ") integration test repo folder(empty?). ");
        }
        return Arrays.asList(allSimulationFiles);
    }

    public <T> T jsonFileToJava(String jsonFileName, Class<T> clazz) throws IOException {
        return (T)this.mapper.readValue(SmartUtils.readJsonAsString(jsonFileName), clazz);
    }

    public List<ScenarioSpec> getScenarioSpecListByPackage(String packageName) {
        List<String> allEndPointFiles = SmartUtils.getAllEndPointFiles(packageName);
        List<ScenarioSpec> scenarioSpecList = allEndPointFiles.stream().map(flowSpecFile -> {
            try {
                return this.jsonFileToJava((String)flowSpecFile, (Class)ScenarioSpec.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while deserializing to Spec. Details: " + e);
            }
        }).collect(Collectors.toList());
        return scenarioSpecList;
    }

    public void checkDuplicateScenarios(String testPackageName) {
        HashSet oops = new HashSet();
        this.getScenarioSpecListByPackage(testPackageName).stream().forEach(scenarioSpec -> {
            if (!oops.add(scenarioSpec.getScenarioName())) {
                throw new RuntimeException("Oops! Can not run with multiple Scenarios with same name. Found duplicate: " + scenarioSpec.getScenarioName());
            }
        });
    }

    public static String prettyPrintJson(String jsonString) {
        ObjectMapper objectMapper = new ObjectMapperProvider().get();
        try {
            JsonNode jsonNode = (JsonNode)objectMapper.readValue(jsonString, JsonNode.class);
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        }
        catch (IOException e) {
            LOGGER.error("Non-JSON content was encountered. So pretty print did not format it and returned the raw text");
            return jsonString;
        }
    }

    public static String prettyPrintJson(JsonNode jsonNode) {
        String indented = jsonNode.toString();
        ObjectMapper objectMapper = new ObjectMapperProvider().get();
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        }
        catch (IOException e) {
            return indented;
        }
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public static List<String> getAllTokens(String aString) {
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(aString);
        ArrayList<String> keyTokens = new ArrayList<String>();
        while (matcher.find()) {
            keyTokens.add(matcher.group(1));
        }
        return keyTokens;
    }

    public static String resolveToken(String stringWithToken, Map<String, String> paramMap) {
        StrSubstitutor sub = new StrSubstitutor(paramMap);
        return sub.replace(stringWithToken);
    }

    public static String getEnvPropertyValue(String envPropertyKey) {
        String propertyValue = System.getProperty(envPropertyKey);
        if (propertyValue != null) {
            return propertyValue;
        }
        return System.getenv(envPropertyKey);
    }
}

