/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.resteasy.client.ClientRequest;
import org.jsmart.zerocode.core.di.ObjectMapperProvider;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelperJsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(HelperJsonUtils.class);
    private static ObjectMapper mapper = new ObjectMapperProvider().get();

    public static String getContentAsItIsJson(Object bodyContent) {
        if (null == bodyContent) {
            return null;
        }
        try {
            String bodyContentAsString = mapper.writeValueAsString(bodyContent);
            JsonNode bodyJsonNode = (JsonNode)mapper.readValue(bodyContentAsString, JsonNode.class);
            if (bodyJsonNode.isValueNode()) {
                return bodyJsonNode.asText();
            }
            if (bodyJsonNode.size() == 0) {
                return null;
            }
            return bodyJsonNode.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> readHeadersAsMap(Object headers) {
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            map = (Map)new ObjectMapperProvider().get().readValue(headers.toString(), HashMap.class);
        }
        catch (IOException e) {
            return map;
        }
        return map;
    }

    public static String createAndReturnAssertionResultJson(int httpResponseCode, String resultBodyContent, String locationHref) {
        logger.debug("\n#locationHref: " + locationHref);
        if (StringUtils.isEmpty((String)resultBodyContent)) {
            resultBodyContent = "{}";
        }
        String locationField = locationHref != null ? "\t\"Location\" : \"" + locationHref + "\",\n" : "";
        String assertJson = "{\n\t\"status\" : " + httpResponseCode + ",\n" + locationField + "\t\"body\" : " + resultBodyContent + "\n" + " }";
        String formattedStr = SmartUtils.prettyPrintJson(assertJson);
        return formattedStr;
    }

    private void setRequestHeaders(Object headers, ClientRequest clientExecutor) {
        Map<String, Object> headersMap = HelperJsonUtils.readHeadersAsMap(headers);
        for (String key : headersMap.keySet()) {
            clientExecutor.header(key, headersMap.get(key));
        }
    }

    public static String javaObjectAsString(Object value) {
        try {
            ObjectMapper ow = new ObjectMapperProvider().get();
            return ow.writeValueAsString(value);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Exception while converting IPT Java Object to JsonString" + e);
        }
    }
}

