/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.runner;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jsmart.zerocode.core.di.ApplicationMainModule;
import org.jsmart.zerocode.core.di.RuntimeHttpClientModule;
import org.jsmart.zerocode.core.domain.HostProperties;
import org.jsmart.zerocode.core.domain.JsonTestCase;
import org.jsmart.zerocode.core.domain.ScenarioSpec;
import org.jsmart.zerocode.core.domain.TargetEnv;
import org.jsmart.zerocode.core.domain.UseHttpClient;
import org.jsmart.zerocode.core.engine.listener.ZeroCodeTestReportListener;
import org.jsmart.zerocode.core.httpclient.RestEasyDefaultHttpClient;
import org.jsmart.zerocode.core.report.ZeroCodeReportGenerator;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunner;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunnerImpl;
import org.jsmart.zerocode.core.utils.RunnerUtils;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeUnitRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeUnitRunner.class);
    static int i = 1;
    protected boolean passed;
    protected boolean testRunCompleted;
    private ZeroCodeMultiStepsScenarioRunner zeroCodeMultiStepsScenarioRunner;
    private final Class<?> testClass;
    Injector injector;
    SmartUtils smartUtils;
    private HostProperties hostProperties;
    private String host;
    private String context;
    private int port;
    List<String> smartTestCaseNames = new ArrayList<String>();
    String currentTestCase;

    public ZeroCodeUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.testClass = klass;
        this.smartUtils = this.getInjectedSmartUtilsClass();
        this.smartTestCaseNames = this.getSmartChildrenList();
        this.hostProperties = this.testClass.getAnnotation(HostProperties.class);
        if (this.hostProperties != null) {
            this.host = this.hostProperties.host();
            this.port = this.hostProperties.port();
            this.context = this.hostProperties.context();
        }
    }

    private List<String> getSmartChildrenList() {
        List children = this.getChildren();
        children.forEach(frameworkMethod -> {
            JsonTestCase annotation = (JsonTestCase)frameworkMethod.getAnnotation(JsonTestCase.class);
            if (annotation != null) {
                this.smartTestCaseNames.add(annotation.value());
            } else {
                this.smartTestCaseNames.add(frameworkMethod.getName());
            }
        });
        return this.smartTestCaseNames;
    }

    public void run(RunNotifier notifier) {
        notifier.addListener((RunListener)new ZeroCodeTestReportListener(this.smartUtils.getMapper(), this.getInjectedReportGenerator()));
        super.run(notifier);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (this.isIgnored(method)) {
            notifier.fireTestIgnored(description);
        } else {
            JsonTestCase annotation = method.getMethod().getAnnotation(JsonTestCase.class);
            this.currentTestCase = annotation != null ? annotation.value() : method.getName();
            notifier.fireTestStarted(description);
            LOGGER.debug("### Running currentTestCase : " + this.currentTestCase);
            ScenarioSpec child = null;
            try {
                child = this.smartUtils.jsonFileToJava(this.currentTestCase, ScenarioSpec.class);
                LOGGER.debug("### Found currentTestCase : -" + child);
                ZeroCodeMultiStepsScenarioRunner multiStepsRunner = this.getInjectedMultiStepsRunner();
                if (this.hostProperties != null) {
                    ((ZeroCodeMultiStepsScenarioRunnerImpl)multiStepsRunner).overrideHost(this.host);
                    ((ZeroCodeMultiStepsScenarioRunnerImpl)multiStepsRunner).overridePort(this.port);
                    ((ZeroCodeMultiStepsScenarioRunnerImpl)multiStepsRunner).overrideApplicationContext(this.context);
                }
                this.passed = multiStepsRunner.runScenario(child, notifier, description);
            }
            catch (Exception ioEx) {
                ioEx.printStackTrace();
                notifier.fireTestFailure(new Failure(description, (Throwable)ioEx));
            }
            this.testRunCompleted = true;
            if (this.passed) {
                LOGGER.info(String.format("\n**FINISHED executing all Steps for [%s] **.\nSteps were:%s", child.getScenarioName(), child.getSteps().stream().map(step -> step.getName()).collect(Collectors.toList())));
            }
            notifier.fireTestFinished(description);
        }
    }

    public List<String> getSmartTestCaseNames() {
        return this.smartTestCaseNames;
    }

    public String getCurrentTestCase() {
        return this.currentTestCase;
    }

    private ZeroCodeMultiStepsScenarioRunner getInjectedMultiStepsRunner() {
        this.zeroCodeMultiStepsScenarioRunner = (ZeroCodeMultiStepsScenarioRunner)this.getMainModuleInjector().getInstance(ZeroCodeMultiStepsScenarioRunner.class);
        return this.zeroCodeMultiStepsScenarioRunner;
    }

    public Injector getMainModuleInjector() {
        TargetEnv envAnnotation = this.testClass.getAnnotation(TargetEnv.class);
        String serverEnv = envAnnotation != null ? envAnnotation.value() : "config_hosts.properties";
        serverEnv = RunnerUtils.getEnvSpecificConfigFile(serverEnv, this.testClass);
        UseHttpClient httpClientAnnotated = this.testClass.getAnnotation(UseHttpClient.class);
        Class runtimeHttpClient = httpClientAnnotated != null ? httpClientAnnotated.value() : RestEasyDefaultHttpClient.class;
        this.injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new ApplicationMainModule(serverEnv)}).with(new Module[]{new RuntimeHttpClientModule(runtimeHttpClient)})});
        return this.injector;
    }

    protected SmartUtils getInjectedSmartUtilsClass() {
        return (SmartUtils)this.getMainModuleInjector().getInstance(SmartUtils.class);
    }

    protected ZeroCodeReportGenerator getInjectedReportGenerator() {
        return (ZeroCodeReportGenerator)this.getMainModuleInjector().getInstance(ZeroCodeReportGenerator.class);
    }
}

