/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.report;

import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.jsmart.zerocode.core.domain.reports.chart.HighChartColumnHtml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighChartColumnHtmlWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighChartColumnHtmlWriter.class);
    public static final String VELOCITY_HIGH_CHART_DEFAULT_FILE = "reports/01_high_chart_column.vm";
    private VelocityEngine vEngine = new VelocityEngine();
    private String templateFile;

    public HighChartColumnHtmlWriter() {
    }

    public HighChartColumnHtmlWriter(String templateFile) {
        this.templateFile = templateFile;
    }

    public String generateHighChart(HighChartColumnHtml highChartColumnHtml, String spikeChartFileName) {
        this.vEngine.setProperty("resource.loader", (Object)"classpath");
        this.vEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        this.vEngine.init();
        VelocityContext context = new VelocityContext();
        context.put("highChartColumnHtml", (Object)highChartColumnHtml);
        Template t = this.vEngine.getTemplate(this.getTemplateFileElseDefault());
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter("target/" + spikeChartFileName);
            t.merge((Context)context, (Writer)fileWriter);
            fileWriter.close();
        }
        catch (IOException chartEx) {
            chartEx.printStackTrace();
            LOGGER.error("Problem occurred during generating test chart. Detail: " + chartEx);
        }
        StringWriter writer = new StringWriter();
        t.merge((Context)context, (Writer)writer);
        String htmlOut = writer.toString();
        return htmlOut;
    }

    private String getTemplateFileElseDefault() {
        if (this.templateFile != null) {
            return this.templateFile;
        }
        return VELOCITY_HIGH_CHART_DEFAULT_FILE;
    }
}

