/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.httpclient.ssl;

import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jsmart.zerocode.core.httpclient.BasicHttpClient;
import org.jsmart.zerocode.core.utils.HelperJsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslTrustHttpClient
implements BasicHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslTrustHttpClient.class);
    private Object COOKIE_JSESSIONID_VALUE;

    @Override
    public Response execute(String httpUrl, String methodName, Map<String, Object> headers, Map<String, Object> queryParams, Object body) throws Exception {
        LOGGER.info("###Used SSL Enabled Http Client");
        String reqBodyAsString = HelperJsonUtils.getContentAsItIsJson(body);
        CloseableHttpClient httpclient = this.createSslHttpClient();
        if (queryParams != null) {
            httpUrl = this.setQueryParams(httpUrl, queryParams);
        }
        RequestBuilder requestBuilder = RequestBuilder.create((String)methodName).setUri(httpUrl);
        if (reqBodyAsString != null) {
            HttpEntity httpEntity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(reqBodyAsString).build();
            requestBuilder.setEntity(httpEntity);
        }
        if (headers != null) {
            Map<String, Object> headersMap = headers;
            for (String key : headersMap.keySet()) {
                requestBuilder.addHeader(key, (String)headersMap.get(key));
            }
        }
        if (this.COOKIE_JSESSIONID_VALUE != null) {
            requestBuilder.addHeader("Cookie", (String)this.COOKIE_JSESSIONID_VALUE);
        }
        CloseableHttpResponse httpResponse = httpclient.execute(requestBuilder.build());
        Response serverResponse = Response.status((int)httpResponse.getStatusLine().getStatusCode()).entity((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)"UTF-8")).build();
        Header[] allHeaders = httpResponse.getAllHeaders();
        Response.ResponseBuilder responseBuilder = Response.fromResponse((Response)serverResponse);
        for (Header thisHeader : allHeaders) {
            String headerKey = thisHeader.getName();
            responseBuilder = responseBuilder.header(headerKey, (Object)thisHeader.getValue());
            if (!"Set-Cookie".equals(headerKey)) continue;
            this.COOKIE_JSESSIONID_VALUE = serverResponse.getMetadata().get((Object)headerKey);
        }
        serverResponse = responseBuilder.build();
        return serverResponse;
    }

    private CloseableHttpClient createSslHttpClient() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (certificate, authType) -> true).build();
        BasicCookieStore cookieStore = new BasicCookieStore();
        return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setDefaultCookieStore((CookieStore)cookieStore).build();
    }

    private String setQueryParams(String httpUrl, Map<String, Object> queryParams) {
        String qualifiedQueryParams = this.createQualifiedQueryParams(queryParams);
        httpUrl = httpUrl + qualifiedQueryParams;
        return httpUrl;
    }

    private String createQualifiedQueryParams(Object queryParams) {
        String qualifiedQueryParam = "?";
        Map<String, Object> queryParamsMap = HelperJsonUtils.readHeadersAsMap(queryParams);
        for (String key : queryParamsMap.keySet()) {
            if ("?".equals(qualifiedQueryParam)) {
                qualifiedQueryParam = qualifiedQueryParam + String.format("%s=%s", key, queryParamsMap.get(key));
                continue;
            }
            qualifiedQueryParam = qualifiedQueryParam + String.format("&%s=%s", key, queryParamsMap.get(key));
        }
        return qualifiedQueryParam;
    }
}

