/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.httpclient;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClientExecutor;
import org.jsmart.zerocode.core.httpclient.BasicHttpClient;
import org.jsmart.zerocode.core.utils.HelperJsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestEasyDefaultHttpClient
implements BasicHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(RestEasyDefaultHttpClient.class);
    private static ApacheHttpClientExecutor httpClientExecutor = new ApacheHttpClientExecutor();
    private ClientRequest clientExecutor;
    private Object COOKIE_JSESSIONID_VALUE;

    @Override
    public Response execute(String httpUrl, String methodName, Map<String, Object> headers, Map<String, Object> queryParams, Object body) throws Exception {
        logger.info("###Used RestEasyDefaultHttpClient");
        String reqBodyAsString = HelperJsonUtils.getContentAsItIsJson(body);
        if (queryParams != null) {
            String qualifiedQueryParams = this.createQualifiedQueryParams(queryParams);
            httpUrl = httpUrl + qualifiedQueryParams;
        }
        this.clientExecutor = httpClientExecutor.createRequest(httpUrl);
        if (headers != null) {
            this.setRequestHeaders(headers, this.clientExecutor);
        }
        if (this.COOKIE_JSESSIONID_VALUE != null) {
            this.clientExecutor.header("Cookie", this.COOKIE_JSESSIONID_VALUE);
        }
        if (reqBodyAsString != null) {
            this.clientExecutor.body("application/json", (Object)reqBodyAsString);
        }
        this.clientExecutor.setHttpMethod(methodName);
        ClientResponse serverResponsePre = this.clientExecutor.execute();
        Response serverResponse = Response.status((int)serverResponsePre.getStatus()).entity(serverResponsePre.getEntity(String.class)).build();
        MultivaluedMap headersMap = serverResponsePre.getHeaders();
        for (Object key : headersMap.keySet()) {
            serverResponse = Response.fromResponse((Response)serverResponse).header((String)key, headersMap.get(key)).build();
        }
        Set headerKeySet = serverResponse.getMetadata().keySet();
        for (Object key : headerKeySet) {
            if (!"Set-Cookie".equals(key)) continue;
            this.COOKIE_JSESSIONID_VALUE = serverResponse.getMetadata().get(key);
        }
        return serverResponse;
    }

    private String createQualifiedQueryParams(Object queryParams) {
        String qualifiedQueryParam = "?";
        Map<String, Object> queryParamsMap = HelperJsonUtils.readHeadersAsMap(queryParams);
        for (String key : queryParamsMap.keySet()) {
            if ("?".equals(qualifiedQueryParam)) {
                qualifiedQueryParam = qualifiedQueryParam + String.format("%s=%s", key, (String)queryParamsMap.get(key));
                continue;
            }
            qualifiedQueryParam = qualifiedQueryParam + String.format("&%s=%s", key, (String)queryParamsMap.get(key));
        }
        return qualifiedQueryParam;
    }

    private ClientRequest setRequestHeaders(Object headers, ClientRequest clientExecutor) {
        HashMap headersMap = (HashMap)headers;
        for (Object key : headersMap.keySet()) {
            clientExecutor.header((String)key, headersMap.get(key));
        }
        return clientExecutor;
    }
}

