/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.executor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.jsmart.zerocode.core.domain.MockSteps;
import org.jsmart.zerocode.core.domain.Response;
import org.jsmart.zerocode.core.engine.executor.JavaExecutor;
import org.jsmart.zerocode.core.engine.executor.JsonServiceExecutor;
import org.jsmart.zerocode.core.engine.mocker.RestEndPointMocker;
import org.jsmart.zerocode.core.httpclient.BasicHttpClient;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonServiceExecutorImpl
implements JsonServiceExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonServiceExecutorImpl.class);
    @Inject
    private JavaExecutor javaExecutor;
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    SmartUtils smartUtils;
    @Inject
    BasicHttpClient httpClient;
    @Inject(optional=true)
    @Named(value="mock.api.port")
    private int mockPort;

    @Override
    public String executeJavaService(String serviceName, String methodName, String requestJson) throws JsonProcessingException {
        if (this.javaExecutor == null) {
            throw new RuntimeException("Can not proceed as the framework could not load the executors. ");
        }
        List<Class<?>> argumentTypes = this.javaExecutor.argumentTypes(serviceName, methodName);
        try {
            Object request = this.objectMapper.readValue(requestJson, argumentTypes.get(0));
            Object result = this.javaExecutor.execute(serviceName, methodName, request);
            String resultJson = this.objectMapper.writeValueAsString(result);
            return SmartUtils.prettyPrintJson(resultJson);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public String executeRESTService(String urlName, String methodName, String requestJson) {
        try {
            String responseJson = this.executeRESTInternal(urlName, methodName, requestJson);
            return responseJson;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new RuntimeException(exc);
        }
    }

    private String executeRESTInternal(String httpUrl, String methodName, String requestJson) throws Exception {
        HashMap queryParams = (HashMap)this.readJsonPathOrElseNull(requestJson, "$.queryParams");
        HashMap headers = (HashMap)this.readJsonPathOrElseNull(requestJson, "$.headers");
        Object bodyContent = this.readJsonPathOrElseNull(requestJson, "$.body");
        if (this.completedMockingEndPoints(httpUrl, requestJson, methodName, bodyContent)) {
            return "{\"status\": 200}";
        }
        javax.ws.rs.core.Response serverResponse = this.httpClient.execute(httpUrl, methodName, headers, queryParams, bodyContent);
        int responseStatus = serverResponse.getStatus();
        MultivaluedMap responseHeaders = serverResponse.getMetadata();
        String responseBodyAsString = (String)serverResponse.getEntity();
        Response zeroCodeResponse = this.deriveZeroCodeResponseFrom(responseStatus, responseHeaders, responseBodyAsString);
        String zeroCodeResponseString = this.objectMapper.writeValueAsString((Object)zeroCodeResponse);
        return SmartUtils.prettyPrintJson(zeroCodeResponseString);
    }

    private Response deriveZeroCodeResponseFrom(int responseStatus, MultivaluedMap responseHeaders, String responseBodyAsString) throws IOException {
        String rawBody;
        JsonNode jsonBody;
        if (StringUtils.isEmpty((String)responseBodyAsString)) {
            jsonBody = null;
            rawBody = null;
        } else if (this.isParsableJson(responseBodyAsString)) {
            jsonBody = (JsonNode)this.objectMapper.readValue(responseBodyAsString, JsonNode.class);
            rawBody = null;
        } else {
            jsonBody = null;
            rawBody = responseBodyAsString;
        }
        return new Response(responseStatus, (Map)responseHeaders, jsonBody, rawBody, null);
    }

    private boolean completedMockingEndPoints(String httpUrl, String requestJson, String methodName, Object bodyContent) throws IOException {
        if (httpUrl.contains("/$MOCK") && methodName.equals("$USE.WIREMOCK")) {
            MockSteps mockSteps = (MockSteps)this.smartUtils.getMapper().readValue(requestJson, MockSteps.class);
            if (this.mockPort > 0) {
                RestEndPointMocker.createWithWireMock(mockSteps, this.mockPort);
                LOGGER.info("#SUCCESS: End points simulated via wiremock.");
                return true;
            }
            LOGGER.error("\n\n#DISABLED: Mocking was not activated as there was no port configured in the properties file. \n\n Usage: e.g. in your <env host config .properties> file provide- \n mock.api.port=8888\n\n");
            return false;
        }
        if (httpUrl.contains("/$MOCK") && methodName.equals("$USE.VIRTUOSO")) {
            LOGGER.info("\n#body:\n" + bodyContent);
            RestEndPointMocker.createWithVirtuosoMock(bodyContent != null ? bodyContent.toString() : null);
            LOGGER.info("#SUCCESS: End point simulated via virtuoso.");
            return true;
        }
        if (httpUrl.contains("/$MOCK") && methodName.equals("$USE.SIMULATOR")) {
            LOGGER.info("\n#body:\n" + bodyContent);
            RestEndPointMocker.createWithLocalMock(bodyContent != null ? bodyContent.toString() : null);
            LOGGER.info("#SUCCESS: End point simulated via local simulator.");
            return true;
        }
        return false;
    }

    private Object readJsonPathOrElseNull(String requestJson, String jsonPath) {
        try {
            return JsonPath.read((String)requestJson, (String)jsonPath, (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException pEx) {
            LOGGER.debug("No " + jsonPath + " was present in the request. returned null.");
            return null;
        }
    }

    private boolean isParsableJson(String potentialJsonString) {
        try {
            this.objectMapper.readTree(potentialJsonString);
            return true;
        }
        catch (IOException e) {
            LOGGER.warn("\n---------------------------------------------\n\n\t\t\t\t\t\t * Warning *  \n\nOutput was not a valid JSON body. It was treated as a simple rawBody. If it was intentional, you can ignore this warning. \n -OR- Update your assertions block with \"rawBody\" instead of \"body\" \n e.g. \"rawBody\" : \"an expected string \"\n\n---------------------------------------------");
            return false;
        }
    }
}

