/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.assertion;

import net.minidev.json.JSONArray;
import org.jsmart.zerocode.core.engine.assertion.AssertionReport;
import org.jsmart.zerocode.core.engine.assertion.JsonAsserter;

public class ArraySizeAsserter
implements JsonAsserter {
    private final String path;
    private final int expectedSize;

    public ArraySizeAsserter(String path, int size) {
        this.path = path;
        this.expectedSize = size;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public AssertionReport actualEqualsToExpected(Object result) {
        if (result instanceof JSONArray) {
            JSONArray actualArrayValue = (JSONArray)result;
            if (actualArrayValue.size() == this.expectedSize) {
                return AssertionReport.createFieldMatchesReport();
            }
            return AssertionReport.createFieldDoesNotMatchReport(this.path, String.format("Array of size %d", this.expectedSize), result);
        }
        return AssertionReport.createFieldDoesNotMatchReport(this.path, "[]", result);
    }
}

