/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.di;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.name.Names;
import java.util.Properties;
import java.util.logging.Logger;
import org.jsmart.zerocode.core.di.HttpClientModule;
import org.jsmart.zerocode.core.di.ObjectMapperModule;
import org.jsmart.zerocode.core.engine.executor.JavaExecutor;
import org.jsmart.zerocode.core.engine.executor.JavaExecutorImpl;
import org.jsmart.zerocode.core.engine.executor.JsonServiceExecutor;
import org.jsmart.zerocode.core.engine.executor.JsonServiceExecutorImpl;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeJsonTestProcesor;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeJsonTestProcesorImpl;
import org.jsmart.zerocode.core.report.ZeroCodeReportGenerator;
import org.jsmart.zerocode.core.report.ZeroCodeReportGeneratorImpl;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunner;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunnerImpl;

public class ApplicationMainModule
extends AbstractModule {
    private static final Logger LOGGER = Logger.getLogger(ApplicationMainModule.class.getName());
    private final String serverEnv;

    public ApplicationMainModule(String serverEnv) {
        this.serverEnv = serverEnv;
    }

    public void configure() {
        this.install(new ObjectMapperModule());
        this.install(new HttpClientModule());
        this.bind(ZeroCodeMultiStepsScenarioRunner.class).to(ZeroCodeMultiStepsScenarioRunnerImpl.class);
        this.bind(JsonServiceExecutor.class).to(JsonServiceExecutorImpl.class);
        this.bind(JavaExecutor.class).to(JavaExecutorImpl.class);
        this.bind(ZeroCodeJsonTestProcesor.class).to(ZeroCodeJsonTestProcesorImpl.class);
        this.bind(ZeroCodeReportGenerator.class).to(ZeroCodeReportGeneratorImpl.class);
        Names.bindProperties((Binder)this.binder(), (Properties)this.getProperties(this.serverEnv));
    }

    public Properties getProperties(String host) {
        Properties properties = new Properties();
        try {
            properties.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(host));
        }
        catch (Exception e) {
            LOGGER.info("###Oops!Exception### while reading target env file: " + host + ". Have you mentioned env details?");
            e.printStackTrace();
            throw new RuntimeException("could not read the target-env properties file --" + host + "-- from the classpath.");
        }
        return properties;
    }
}

