/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class IOHelpers {
    public static String inputStreamToString(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        StringBuilder str = new StringBuilder(128);
        String coding = "UTF-8";
        int c = stream.read();
        if (c == 35) {
            str.append((char)c);
            while ((c = stream.read()) != -1 && c != 10) {
                str.append((char)c);
            }
            Pattern pattern = Pattern.compile("coding:\\s*(\\S+)");
            Matcher matcher = pattern.matcher(str.toString());
            if (matcher.find()) {
                coding = matcher.group(1);
            }
        }
        str.append((char)c);
        InputStreamReader reader = new InputStreamReader(stream, coding);
        while ((c = ((Reader)reader).read()) != -1) {
            str.append((char)c);
        }
        return str.toString();
    }

    public static String rubyMagicCommentValue(String script, String prefix) throws IOException {
        String line;
        if (script == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new StringReader(script), 80);
        String comment = null;
        Pattern pattern = null;
        while ((line = reader.readLine()) != null && line.length() != 0 && line.charAt(0) == '#') {
            Matcher matcher;
            if (pattern == null) {
                pattern = Pattern.compile(prefix + "\\s*(\\S+)");
            }
            if (!(matcher = pattern.matcher(line)).find()) continue;
            comment = matcher.group(1);
            break;
        }
        reader.close();
        return comment;
    }
}

