/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.servlet;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.RackInput;

public class ServletRackEnvironment
extends HttpServletRequestWrapper
implements RackEnvironment,
RackEnvironment.ToIO {
    private String scriptName;
    private String requestURI;
    private String requestURIWithoutQuery;
    private String pathInfo;
    private final RackContext context;
    private final HttpServletResponse response;
    private RackInput io;

    public ServletRackEnvironment(HttpServletRequest request, HttpServletResponse response, RackContext context) {
        super(request);
        this.response = response;
        this.context = context;
    }

    public RackContext getContext() {
        return this.context;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletInputStream getInput() throws IOException {
        return this.getInputStream();
    }

    public String getScriptName() {
        if (this.scriptName != null) {
            return this.scriptName;
        }
        String contextPath = this.getContextPath();
        if (contextPath == null) {
            contextPath = "";
        }
        this.scriptName = contextPath.equals("/") ? "" : contextPath;
        return this.scriptName;
    }

    public String getPathInfo() {
        if (this.pathInfo != null) {
            return this.pathInfo;
        }
        StringBuilder buffer = new StringBuilder();
        if (this.getRequestURIWithoutQuery().length() > 0) {
            if (this.getScriptName().length() > 0 && this.getRequestURIWithoutQuery().indexOf(this.getScriptName()) == 0) {
                buffer.append(this.getRequestURIWithoutQuery().substring(this.getScriptName().length()));
            } else {
                buffer.append(this.getRequestURIWithoutQuery());
            }
        } else {
            buffer.append(this.getServletPath());
            if (super.getPathInfo() != null) {
                buffer.append(super.getPathInfo());
            }
        }
        this.pathInfo = buffer.toString();
        return this.pathInfo;
    }

    public String getRequestURI() {
        if (this.requestURI != null) {
            return this.requestURI;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getRequestURIWithoutQuery());
        if (super.getQueryString() != null) {
            buffer.append("?").append(super.getQueryString());
        }
        this.requestURI = buffer.toString();
        return this.requestURI;
    }

    public String getRequestURIWithoutQuery() {
        if (this.requestURIWithoutQuery != null) {
            return this.requestURIWithoutQuery;
        }
        this.requestURIWithoutQuery = super.getRequestURI();
        if (this.requestURIWithoutQuery == null) {
            this.requestURIWithoutQuery = "";
        }
        return this.requestURIWithoutQuery;
    }

    public RackInput toIO() {
        return this.io;
    }

    public void setIO(RackInput io) {
        this.io = io;
    }
}

