/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import javax.servlet.ServletInputStream;

public class RewindableInputStream
extends ServletInputStream {
    public static final int INI_BUFFER_SIZE = 4096;
    public static final int MAX_BUFFER_SIZE = 16384;
    private static final int TMP_READ_BUFFER_SIZE = 1024;
    public static final String TMP_FILE_PREFIX = "jruby-rack-input_";
    private static int iniBufferSize = 4096;
    private static int maxBufferSize = 16384;
    private final InputStream input;
    private ByteBuffer buffer;
    private final int bufferMax;
    private RandomAccessFile bufferFile = null;
    private String bufferFilePath;
    private long mark = -1L;

    public static int getDefaultInitialBufferSize() {
        return iniBufferSize;
    }

    public static void setDefaultInitialBufferSize(int iniBufferSize) {
        RewindableInputStream.iniBufferSize = iniBufferSize;
    }

    public static int getDefaultMaximumBufferSize() {
        return maxBufferSize;
    }

    public static void setDefaultMaximumBufferSize(int maxBufferSize) {
        RewindableInputStream.maxBufferSize = maxBufferSize;
    }

    public RewindableInputStream(InputStream input) {
        this(input, iniBufferSize, maxBufferSize);
    }

    public RewindableInputStream(InputStream input, int bufferSize) {
        this(input, bufferSize, bufferSize);
    }

    public RewindableInputStream(InputStream input, int iniBufferSize, int maxBufferSize) {
        this.input = input;
        this.buffer = ByteBuffer.allocate(iniBufferSize);
        this.buffer.limit(0);
        this.bufferMax = maxBufferSize;
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        return this.input.available() + this.buffer.remaining();
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int readlimit) {
        try {
            this.mark = this.getPosition();
            this.assureBufferCapacity(readlimit, true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.mark < 0L) {
            throw new IOException("The marked position is invalid");
        }
        this.setPosition(this.mark);
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.fillBuffer(1) == -1) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        int count;
        int len;
        this.ensureOpen();
        for (count = 0; count < length; count += len) {
            len = this.fillBuffer(length - count);
            if (len == -1) {
                return count == 0 ? -1 : count;
            }
            this.buffer.get(buffer, offset + count, len);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.buffer == null) {
            return;
        }
        if (this.bufferFile != null) {
            try {
                this.bufferFile.close();
            }
            finally {
                new File(this.bufferFilePath).delete();
            }
        }
        super.close();
        this.buffer = null;
    }

    public synchronized void rewind() throws IOException {
        this.ensureOpen();
        this.setPosition(0L);
    }

    private void ensureOpen() throws IOException {
        if (this.buffer == null) {
            throw new IOException("IO is closed");
        }
    }

    private int fillBuffer(int count) throws IOException {
        if (!this.isFileBuffered()) {
            this.assureBufferCapacity(count, false);
        }
        if (this.isFileBuffered()) {
            return this.fillBufferFromFile(count);
        }
        if (!this.buffer.hasArray()) {
            throw new IllegalStateException("byte buffer without backing array");
        }
        while (this.buffer.remaining() < count) {
            int read = count - this.buffer.remaining();
            read = this.input.read(this.buffer.array(), this.buffer.limit(), read);
            if (read == -1) {
                if (this.buffer.remaining() != 0) break;
                return -1;
            }
            this.buffer.limit(this.buffer.limit() + read);
        }
        return Math.min(this.buffer.remaining(), count);
    }

    private void assureBufferCapacity(int count, boolean force) throws IOException {
        if (this.buffer.position() + count > this.buffer.capacity()) {
            int newSize = this.buffer.capacity() + Math.max(count, this.buffer.capacity());
            if (newSize <= this.bufferMax) {
                this.buffer = this.copyBuffer(newSize);
            } else if (force) {
                newSize = this.buffer.capacity() + count;
                this.buffer = this.copyBuffer(newSize);
            } else {
                this.setFileBuffered();
            }
        }
    }

    private ByteBuffer copyBuffer(int capacity) {
        ByteBuffer newBuffer = ByteBuffer.allocate(capacity);
        if (!this.buffer.hasArray() || !newBuffer.hasArray()) {
            throw new IllegalStateException("byte buffer without backing array");
        }
        newBuffer.position(this.buffer.position());
        newBuffer.limit(this.buffer.limit());
        System.arraycopy(this.buffer.array(), this.buffer.arrayOffset(), newBuffer.array(), newBuffer.arrayOffset(), this.buffer.limit());
        return newBuffer;
    }

    private int fillBufferFromFile(int count) throws IOException {
        if (this.buffer.remaining() < count) {
            byte[] data;
            int dataLen;
            int read = count - this.buffer.remaining();
            long position = this.bufferFile.getFilePointer();
            while (this.bufferFile.length() - position < (long)read && (dataLen = this.input.read(data = new byte[1024])) != -1) {
                this.bufferFile.seek(this.bufferFile.length());
                this.bufferFile.write(data, 0, dataLen);
                this.bufferFile.seek(position);
            }
            if (this.buffer.limit() + count > this.buffer.capacity() && this.buffer.position() > 0) {
                if (!this.buffer.hasArray()) {
                    throw new IllegalStateException("byte buffer without backing array");
                }
                System.arraycopy(this.buffer.array(), this.buffer.position(), this.buffer.array(), 0, this.buffer.remaining());
                this.buffer.limit(this.buffer.remaining()).position(0);
            }
            int free = this.buffer.capacity() - this.buffer.limit();
            read = this.bufferFile.read(this.buffer.array(), this.buffer.limit(), free);
            if (read == -1 && this.buffer.remaining() == 0) {
                return -1;
            }
            if (read != -1) {
                this.buffer.limit(this.buffer.limit() + read);
            }
        }
        return Math.min(this.buffer.remaining(), count);
    }

    boolean isFileBuffered() {
        return this.bufferFile != null;
    }

    void setFileBuffered() throws IOException {
        if (this.isFileBuffered()) {
            throw new IllegalStateException("already buffered to a file");
        }
        int position = this.buffer.position();
        File tmpFile = File.createTempFile(TMP_FILE_PREFIX, "");
        this.bufferFile = new RandomAccessFile(tmpFile, "rw");
        this.bufferFilePath = tmpFile.getPath();
        this.buffer.position(this.buffer.arrayOffset());
        this.bufferFile.getChannel().write(this.buffer);
        this.setPosition(position);
    }

    private void setPosition(long position) throws IOException {
        if (this.isFileBuffered()) {
            this.buffer.rewind().limit(0);
            this.bufferFile.seek(position);
        } else {
            this.buffer.rewind().position((int)position);
        }
    }

    long getPosition() throws IOException {
        if (this.isFileBuffered()) {
            return this.bufferFile.getFilePointer();
        }
        return this.buffer.position();
    }

    public int getCurrentBufferSize() {
        return this.buffer.capacity();
    }

    public int getMaximumBufferSize() {
        return this.bufferMax;
    }
}

