/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import org.jruby.rack.RackLogger;

public class OutputStreamLogger
implements RackLogger {
    private final PrintStream out;

    public OutputStreamLogger(OutputStream out) {
        this(new PrintStream(out));
    }

    public OutputStreamLogger(PrintStream out) {
        if (out == null) {
            throw new IllegalArgumentException("no out stream");
        }
        this.out = out;
    }

    public void log(String message) {
        this.printMessage(message);
        this.out.flush();
    }

    public void log(String message, Throwable e) {
        this.printMessage(message);
        e.printStackTrace(this.out);
        this.out.flush();
    }

    public void log(String level, String message) {
        this.out.print(level);
        this.out.print(": ");
        this.log(message);
    }

    public void log(String level, String message, Throwable e) {
        this.out.print(level);
        this.out.print(": ");
        this.log(message, e);
    }

    private void printMessage(String message) {
        if (message.charAt(message.length() - 1) == '\n') {
            this.out.print(message);
        } else {
            this.out.println(message);
        }
    }
}

