/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jruby.rack.RackLogger;

public class JulLogger
implements RackLogger {
    private Logger logger;

    public JulLogger() {
        this.setLoggerName("");
    }

    public JulLogger(String loggerName) {
        this.setLoggerName(loggerName);
    }

    public void setLoggerName(String loggerName) {
        this.logger = Logger.getLogger(loggerName);
    }

    public void log(String message) {
        this.logger.log(Level.INFO, message);
    }

    public void log(String message, Throwable e) {
        this.logger.log(Level.SEVERE, message, e);
    }

    public void log(String level, String message) {
        this.logger.log(JulLogger.mapLevel(level, Level.INFO), message);
    }

    public void log(String level, String message, Throwable e) {
        this.logger.log(JulLogger.mapLevel(level, Level.SEVERE), message, e);
    }

    private static Level mapLevel(String level, Level defaultLevel) {
        if ("ERROR".equals(level)) {
            return Level.SEVERE;
        }
        if ("WARN".equals(level)) {
            return Level.WARNING;
        }
        if ("INFO".equals(level)) {
            return Level.INFO;
        }
        if ("DEBUG".equals(level)) {
            return Level.FINE;
        }
        return defaultLevel;
    }
}

