/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.ext;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"JRuby::Rack::Logger"})
public class Logger
extends RubyObject {
    protected Logger(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyClass(name={"JRuby::Rack::ServletLog"})
    public static class ServletLog
    extends RubyObject {
        protected ServletLog(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod(required=0, optional=1)
        public IRubyObject initialize(ThreadContext context, IRubyObject[] args) {
            IRubyObject rackContext;
            if (args != null && args.length > 0) {
                rackContext = args[0];
            } else {
                IRubyObject jrubyRack = context.runtime.getModule("JRuby").getConstant("Rack");
                rackContext = jrubyRack.callMethod(context, "context");
            }
            if (rackContext.isNil()) {
                throw context.runtime.newArgumentError("no context");
            }
            this.setInstanceVariable("@context", rackContext);
            return this;
        }

        @JRubyMethod
        public IRubyObject write(ThreadContext context, IRubyObject msg) {
            return this.getInstanceVariable("@context").callMethod(context, "log", msg);
        }

        @JRubyMethod
        public IRubyObject puts(ThreadContext context, IRubyObject msg) {
            return this.callMethod(context, "write", msg);
        }

        @JRubyMethod(name={"close"}, alias={"flush"})
        public IRubyObject close(ThreadContext context) {
            return context.runtime.getNil();
        }
    }
}

