/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.embed;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaUtil;
import org.jruby.rack.AbstractRackDispatcher;
import org.jruby.rack.DefaultRackApplication;
import org.jruby.rack.RackApplication;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.RackInitializationException;
import org.jruby.rack.RackResponseEnvironment;
import org.jruby.rack.embed.Context;
import org.jruby.runtime.builtin.IRubyObject;

public class Dispatcher
extends AbstractRackDispatcher {
    protected final IRubyObject application;
    private RackApplication rackApplication;

    public Dispatcher(RackContext rackContext, IRubyObject application) {
        super(rackContext);
        this.application = application;
        this.initialize();
    }

    private void initialize() {
        Ruby runtime = this.application.getRuntime();
        if (this.context instanceof Context) {
            ((Context)this.context).getConfig().doInitialize(runtime);
        }
        IRubyObject rubyContext = JavaUtil.convertJavaToRuby((Ruby)runtime, (Object)this.context);
        IRubyObject rackModule = runtime.getModule("JRuby").getConstantAt("Rack");
        rackModule.callMethod(runtime.getCurrentContext(), "context=", rubyContext);
        runtime.getGlobalVariables().set("$servlet_context", rubyContext);
    }

    protected RackApplication getApplication() throws RackInitializationException {
        if (this.rackApplication == null) {
            this.rackApplication = new DefaultRackApplication(this.application);
            this.rackApplication.init();
        }
        return this.rackApplication;
    }

    public void destroy() {
        if (this.rackApplication != null) {
            this.rackApplication.destroy();
        }
        this.rackApplication = null;
    }

    protected void afterException(RackEnvironment env, Exception re, RackResponseEnvironment response) throws IOException {
        this.context.log("Error:", re);
        response.sendError(500);
    }

    protected void afterProcess(RackApplication app) throws IOException {
    }
}

