/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.util.Collection;
import java.util.Collections;
import org.jruby.rack.RackApplication;
import org.jruby.rack.RackApplicationFactory;
import org.jruby.rack.RackApplicationFactoryDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedRackApplicationFactory
extends RackApplicationFactoryDecorator {
    private RackApplication application;

    public SharedRackApplicationFactory(RackApplicationFactory delegate) {
        super(delegate);
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        this.log("INFO", "using a shared (threadsafe!) runtime");
        this.application = this.getDelegate().getApplication();
    }

    @Override
    protected RackApplication getApplicationImpl() {
        return this.application;
    }

    @Override
    public RackApplication newApplication() {
        return this.getApplication();
    }

    @Override
    public void finishedWithApplication(RackApplication app) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.application != null) {
            SharedRackApplicationFactory sharedRackApplicationFactory = this;
            synchronized (sharedRackApplicationFactory) {
                if (this.application != null) {
                    this.getDelegate().finishedWithApplication(this.application);
                }
            }
        }
        super.destroy();
    }

    @Override
    public Collection<RackApplication> getManagedApplications() {
        if (this.application == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.application);
    }
}

