/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jruby.rack.DefaultRackApplicationFactory;
import org.jruby.rack.DefaultRackConfig;
import org.jruby.rack.PoolingRackApplicationFactory;
import org.jruby.rack.RackApplicationFactory;
import org.jruby.rack.RackConfig;
import org.jruby.rack.RackInitializationException;
import org.jruby.rack.SerialPoolingRackApplicationFactory;
import org.jruby.rack.SharedRackApplicationFactory;
import org.jruby.rack.servlet.DefaultServletRackContext;
import org.jruby.rack.servlet.ServletRackConfig;
import org.jruby.rack.servlet.ServletRackContext;

public class RackServletContextListener
implements ServletContextListener {
    private final RackApplicationFactory factory;

    public RackServletContextListener() {
        this.factory = null;
    }

    RackServletContextListener(RackApplicationFactory factory) {
        this.factory = factory;
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        ServletRackConfig config = new ServletRackConfig(context);
        RackApplicationFactory factory = this.newApplicationFactory(config);
        context.setAttribute("rack.factory", (Object)factory);
        DefaultServletRackContext rackContext = new DefaultServletRackContext(config);
        context.setAttribute("rack.context", (Object)rackContext);
        try {
            factory.init(rackContext);
        }
        catch (RuntimeException e) {
            this.handleInitializationException(e, factory, rackContext);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        RackApplicationFactory factory = (RackApplicationFactory)context.getAttribute("rack.factory");
        if (factory != null) {
            context.removeAttribute("rack.factory");
            context.removeAttribute("rack.context");
            factory.destroy();
        }
    }

    protected RackApplicationFactory newApplicationFactory(RackConfig config) {
        if (this.factory != null) {
            return this.factory;
        }
        DefaultRackApplicationFactory factory = new DefaultRackApplicationFactory();
        Integer maxRuntimes = config.getMaximumRuntimes();
        if (maxRuntimes == null || maxRuntimes == 1) {
            return new SharedRackApplicationFactory(factory);
        }
        return config.isSerialInitialization() ? new SerialPoolingRackApplicationFactory(factory) : new PoolingRackApplicationFactory(factory);
    }

    protected void handleInitializationException(Exception e, RackApplicationFactory factory, ServletRackContext rackContext) {
        if (DefaultRackConfig.isThrowInitException(rackContext.getConfig())) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw RackInitializationException.wrap(e);
        }
        rackContext.log("ERROR", "initialization failed", e);
    }
}

