/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.rack.AcquireTimeoutException;
import org.jruby.rack.RackApplication;
import org.jruby.rack.RackApplicationFactory;
import org.jruby.rack.RackApplicationFactoryDecorator;
import org.jruby.rack.RackConfig;
import org.jruby.rack.RackInitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolingRackApplicationFactory
extends RackApplicationFactoryDecorator {
    private static final float ACQUIRE_DEFAULT = 10.0f;
    protected final Queue<RackApplication> applicationPool = new LinkedList<RackApplication>();
    private Integer initialSize;
    private Integer maximumSize;
    private final AtomicInteger initedApplications = new AtomicInteger(0);
    private final AtomicInteger createdApplications = new AtomicInteger(0);
    private float acquireTimeout = 10.0f;
    private Semaphore permits;

    public PoolingRackApplicationFactory(RackApplicationFactory delegate) {
        super(delegate);
    }

    public Collection<RackApplication> getApplicationPool() {
        return this.applicationPool;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(Integer initialSize) {
        this.initialSize = initialSize;
        if (initialSize != null && this.maximumSize != null && initialSize > this.maximumSize) {
            this.setMaximumSize(initialSize);
        }
    }

    public Integer getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(Integer maximumSize) {
        if (maximumSize != null && this.initialSize != null && this.initialSize > maximumSize) {
            maximumSize = this.initialSize;
        }
        this.maximumSize = maximumSize;
    }

    public Number getAcquireTimeout() {
        return Float.valueOf(this.acquireTimeout);
    }

    public void setAcquireTimeout(Number acquireTimeout) {
        this.acquireTimeout = acquireTimeout == null ? 10.0f : acquireTimeout.floatValue();
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        RackConfig config = this.getConfig();
        Number timeout = config.getNumberProperty("jruby.runtime.acquire.timeout");
        if (timeout == null) {
            timeout = config.getNumberProperty("jruby.runtime.timeout.sec");
        }
        this.setAcquireTimeout(timeout);
        this.setInitialSize(config.getInitialRuntimes());
        this.setMaximumSize(config.getMaximumRuntimes());
        this.log("INFO", "using " + (this.initialSize == null ? "" : this.initialSize) + ":" + (this.maximumSize == null ? "" : this.maximumSize) + " runtime pool with acquire timeout of " + this.acquireTimeout + " seconds");
        this.fillInitialPool();
        RuntimeException error = this.getInitError();
        if (error != null) {
            throw error;
        }
    }

    @Override
    public RackApplication newApplication() throws RackInitializationException, AcquireTimeoutException {
        return this.getApplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RackApplication getApplicationImpl() throws RackInitializationException, AcquireTimeoutException {
        RackApplication app = null;
        boolean permit = this.acquireApplicationPermit();
        Queue<RackApplication> queue = this.applicationPool;
        synchronized (queue) {
            if (!this.applicationPool.isEmpty()) {
                app = this.applicationPool.remove();
            } else if (permit && this.initialSize != null && this.initialSize > this.initedApplications.get()) {
                do {
                    this.waitForApplication();
                } while (this.applicationPool.isEmpty());
                app = this.applicationPool.remove();
            }
        }
        if (app != null) {
            return app;
        }
        if (!permit || this.maximumSize == null || this.maximumSize > this.createdApplications.get()) {
            this.log("INFO", "pool was empty - getting new application instance");
            return this.createApplication(true);
        }
        throw new IllegalStateException("retrieved a null from the pool, please check the log for previous initialization errors");
    }

    protected boolean acquireApplicationPermit() throws AcquireTimeoutException {
        if (this.permits != null) {
            boolean acquired = false;
            try {
                long timeout = (long)(this.acquireTimeout * 1000.0f);
                acquired = this.permits.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AcquireTimeoutException("could not acquire application permit", e);
            }
            if (!acquired) {
                String message = "could not acquire application permit within " + this.acquireTimeout + " seconds";
                this.log("INFO", message + " (try increasing the pool size)");
                throw new AcquireTimeoutException(message);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishedWithApplication(RackApplication app) {
        if (app == null) {
            this.log("WARN", "ignoring null application");
            return;
        }
        Queue<RackApplication> queue = this.applicationPool;
        synchronized (queue) {
            if (this.maximumSize != null && this.applicationPool.size() >= this.maximumSize) {
                return;
            }
            if (this.applicationPool.contains(app)) {
                return;
            }
            this.applicationPool.add(app);
            if (this.permits != null) {
                this.permits.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Queue<RackApplication> queue = this.applicationPool;
        synchronized (queue) {
            for (RackApplication app : this.applicationPool) {
                this.getDelegate().finishedWithApplication(app);
            }
            this.applicationPool.clear();
        }
        super.destroy();
    }

    public void fillInitialPool() throws RackInitializationException {
        Semaphore semaphore = this.permits = this.maximumSize != null ? new Semaphore(this.maximumSize, true) : null;
        if (this.initialSize != null) {
            Queue<RackApplication> apps = this.createApplications();
            this.launchInitializerThreads(apps);
            this.waitTillPoolReady();
        }
    }

    @Deprecated
    protected void launchInitializerThreads(Queue<RackApplication> apps) {
        this.launchInitialization(apps);
    }

    protected void launchInitialization(final Queue<RackApplication> apps) {
        Integer initThreads = this.getConfig().getNumInitializerThreads();
        if (initThreads == null) {
            initThreads = 4;
        }
        for (int i = 0; i < initThreads; ++i) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    RackApplication app;
                    do {
                        Queue queue = apps;
                        synchronized (queue) {
                            if (apps.isEmpty()) {
                                break;
                            }
                            app = (RackApplication)apps.remove();
                        }
                    } while (PoolingRackApplicationFactory.this.initAndPutApplicationToPool(app));
                }
            }, "JRuby-Rack-App-Init-" + i).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initAndPutApplicationToPool(RackApplication app) {
        try {
            app.init();
        }
        catch (RuntimeException e) {
            PoolingRackApplicationFactory poolingRackApplicationFactory = this;
            synchronized (poolingRackApplicationFactory) {
                RuntimeException initError = this.getInitError();
                this.setInitError(e);
                if (initError == null || !initError.getClass().equals(e.getClass()) || !initError.getMessage().equals(e.getMessage())) {
                    this.log("ERROR", "unable to initialize application", e);
                }
            }
            return this.putApplicationToPool(null);
        }
        return this.putApplicationToPool(app);
    }

    protected Queue<RackApplication> createApplications() throws RackInitializationException {
        LinkedList<RackApplication> apps = new LinkedList<RackApplication>();
        for (int i = 0; i < this.initialSize; ++i) {
            apps.add(this.createApplication(false));
        }
        return apps;
    }

    private synchronized RackApplication createApplication(boolean init) throws RackInitializationException {
        this.createdApplications.incrementAndGet();
        if (init) {
            this.initedApplications.incrementAndGet();
        }
        return init ? this.getDelegate().getApplication() : this.getDelegate().newApplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putApplicationToPool(RackApplication app) {
        Queue<RackApplication> queue = this.applicationPool;
        synchronized (queue) {
            if (this.maximumSize != null && this.applicationPool.size() >= this.maximumSize) {
                return false;
            }
            this.applicationPool.add(app);
            this.log("INFO", "added application to pool, size now = " + this.applicationPool.size());
            this.initedApplications.incrementAndGet();
            this.applicationPool.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitTillPoolReady() {
        int waitFor = this.getInitialPoolSizeWait();
        while (true) {
            Queue<RackApplication> queue = this.applicationPool;
            synchronized (queue) {
                if (this.applicationPool.size() >= waitFor) {
                    break;
                }
                this.waitForApplication();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForApplication() {
        Queue<RackApplication> queue = this.applicationPool;
        synchronized (queue) {
            try {
                this.applicationPool.wait(5000L);
            }
            catch (InterruptedException ignore) {
                return;
            }
        }
    }

    private int getInitialPoolSizeWait() {
        Number waitNum = this.getConfig().getNumberProperty("jruby.runtime.init.wait");
        if (waitNum != null) {
            int wait = waitNum.intValue();
            if (this.maximumSize != null && wait > this.maximumSize) {
                wait = this.maximumSize;
            }
            return wait;
        }
        Boolean waitFlag = this.getConfig().getBooleanProperty("jruby.runtime.init.wait");
        if (waitFlag == null) {
            waitFlag = Boolean.TRUE;
        }
        return waitFlag.booleanValue() ? (this.initialSize == null ? 1 : this.initialSize) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RackApplication> getManagedApplications() {
        Queue<RackApplication> queue = this.applicationPool;
        synchronized (queue) {
            if (this.applicationPool.isEmpty()) {
                return Collections.emptySet();
            }
            ArrayList<RackApplication> snapshot = new ArrayList<RackApplication>(this.applicationPool);
            return Collections.unmodifiableCollection(snapshot);
        }
    }
}

