/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.rack.DefaultRackApplication;
import org.jruby.rack.ErrorApplication;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.RackException;
import org.jruby.rack.RackResponse;
import org.jruby.rack.RackResponseEnvironment;

public class DefaultErrorApplication
extends DefaultRackApplication
implements ErrorApplication {
    protected final RackContext context;

    public DefaultErrorApplication() {
        this((RackContext)null);
    }

    DefaultErrorApplication(RackContext context) {
        this.context = context;
    }

    public Ruby getRuntime() {
        throw new UnsupportedOperationException("getRuntime() not supported");
    }

    public void init() {
    }

    public void destroy() {
    }

    public RackResponse call(RackEnvironment env) throws RackException {
        return new Response(env);
    }

    static Exception getException(RackEnvironment env) {
        return (Exception)env.getAttribute("jruby.rack.exception");
    }

    private class Response
    implements RackResponse {
        private int status = 500;
        private Map headers = Collections.EMPTY_MAP;
        private String body;
        protected final RackEnvironment env;

        public Response(RackEnvironment env) {
            this.env = env;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public Map getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map headers) {
            this.headers = headers == null ? Collections.EMPTY_MAP : headers;
        }

        public String getBody() {
            if (this.body == null) {
                try {
                    this.body = this.buildErrorBody();
                }
                catch (Exception e) {
                    this.log("INFO", "failed building error body", e);
                    this.body = this.getError() == null ? "" : this.getError().toString();
                }
            }
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public Exception getError() {
            return DefaultErrorApplication.getException(this.env);
        }

        protected String buildErrorBody() {
            StringWriter stringWriter = new StringWriter(1024);
            if (this.getError() != null) {
                PrintWriter printWriter = new PrintWriter(stringWriter);
                this.getError().printStackTrace(printWriter);
                printWriter.println();
                printWriter.close();
            }
            return stringWriter.toString();
        }

        public void respond(RackResponseEnvironment response) {
            try {
                response.defaultRespond(this);
            }
            catch (IOException e) {
                this.log("WARN", "could not write response body", e);
            }
        }

        private void log(String level, String message, Throwable e) {
            if (DefaultErrorApplication.this.context != null) {
                DefaultErrorApplication.this.context.log(level, message, e);
            }
        }
    }
}

