/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.jruby.AbstractJRubyMojo;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="pom", requiresProject=false)
public class PomMojo
extends AbstractJRubyMojo {
    @Parameter(defaultValue="${plugin}", readonly=true)
    PluginDescriptor plugin;
    @Parameter(property="pom", defaultValue="pom.xml")
    protected File pom;
    @Parameter(property="pom.force", defaultValue="false")
    protected boolean force;
    @Parameter(defaultValue="${project.build.directory}/pom.xml")
    protected File tmpPom;
    @Parameter(property="pom.gemspec", defaultValue="gemspec")
    protected File gemspec;
    @Parameter(property="pom.gemfile", defaultValue="Gemfile")
    protected File gemfile;
    @Parameter
    private boolean skipGeneration;

    public void executeJRuby() throws MojoExecutionException, ScriptException, IOException {
        if (this.tmpPom.getPath().contains("${project.basedir}")) {
            this.tmpPom = new File(this.tmpPom.getPath().replace("${project.basedir}/", ""));
        }
        File source = null;
        if (this.skipGeneration) {
            this.gemfile = null;
            this.gemspec = null;
        } else {
            if (this.gemfile.exists()) {
                this.gemspec = null;
            } else {
                this.gemfile = null;
                if (this.gemspec == null) {
                    this.gemspec = this.findGemspec();
                }
            }
            if (this.gemspec != null) {
                this.generatePom(this.gemspec, "gemspec");
                source = this.gemspec;
            }
            if (this.gemfile != null) {
                this.generatePom(this.gemfile, "gemfile");
                source = this.gemspec;
            }
        }
        this.copyGeneratedPom(source);
    }

    private void copyGeneratedPom(File source) throws IOException {
        if (this.pom.exists() && this.tmpPom.exists()) {
            String pomString = FileUtils.fileRead((File)this.pom);
            String tmpString = FileUtils.fileRead((File)this.tmpPom);
            if (this.force || source == null && !pomString.equals(tmpString) || source != null && source.lastModified() > this.pom.lastModified()) {
                this.movePom();
            } else if (this.jrubyVerbose) {
                if (source != null) {
                    this.getLog().info((CharSequence)"skip creation of pom. force creation with -Dpom.force");
                } else {
                    this.rubyMavenHelper();
                    this.tmpPom.delete();
                    this.getLog().info((CharSequence)("generated pom up to date - deleted " + this.tmpPom.getAbsolutePath().replace(this.project.getBasedir().getAbsolutePath() + "/", "")));
                }
            }
        } else if (this.tmpPom.exists()) {
            this.movePom();
        }
    }

    private void movePom() throws IOException {
        FileUtils.rename((File)this.tmpPom, (File)this.pom);
        this.rubyMavenHelper();
        if (this.jrubyVerbose) {
            this.getLog().info((CharSequence)("moved " + this.tmpPom.getAbsolutePath().replace(this.project.getBasedir().getAbsolutePath() + "/", "") + " to " + this.pom.getAbsolutePath().replace(this.project.getBasedir().getAbsolutePath() + "/", "")));
        }
    }

    private void rubyMavenHelper() {
        if (this.project.getFile() != null && this.project.getFile().getAbsolutePath().equals(this.tmpPom.getAbsolutePath())) {
            this.project.setFile(this.pom);
        }
    }

    private void generatePom(File file, String type) throws ScriptException, IOException {
        this.tmpPom.getParentFile().mkdirs();
        URL url = Thread.currentThread().getContextClassLoader().getResource("maven/tools/pom.rb");
        this.factory.newScript("$LOAD_PATH << '" + url.toString().replace("maven/tools/pom.rb", "") + "';require 'maven/tools/pom';puts Maven::Tools::POM.new('" + file.getAbsolutePath() + "').to_s").execute(this.tmpPom);
    }

    private File findGemspec() {
        this.getLog().debug((CharSequence)"no gemspec file given, see if there is single one");
        File result = null;
        File basedir = this.project.getBasedir() == null ? new File(".") : this.project.getBasedir();
        for (File file : basedir.listFiles()) {
            if (!file.getName().endsWith(".gemspec")) continue;
            if (result != null) {
                this.getLog().info((CharSequence)"there is no gemspec file given but there are more then one in the current directory.");
                this.getLog().info((CharSequence)"use '-Dpom.gemspec=...' to select the gemspec file or -Dpom.gemfile to select a Gemfile to process");
                return null;
            }
            result = file;
        }
        return result;
    }
}

