/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import jnr.ffi.provider.Invoker;

public class NativeInvocationHandler
implements InvocationHandler {
    private volatile Map<Method, Invoker> fastLookupTable;
    private final Map<Method, Invoker> invokerMap;

    public NativeInvocationHandler(Map<Method, Invoker> invokers) {
        this.invokerMap = invokers;
        this.fastLookupTable = Collections.emptyMap();
    }

    @Override
    public Object invoke(Object self2, Method method, Object[] argArray) throws Throwable {
        Invoker invoker = this.fastLookupTable.get(method);
        return invoker != null ? invoker.invoke(self2, argArray) : this.lookupAndCacheInvoker(method).invoke(self2, argArray);
    }

    private synchronized Invoker lookupAndCacheInvoker(Method method) {
        Invoker invoker = this.fastLookupTable.get(method);
        if (invoker != null) {
            return invoker;
        }
        IdentityHashMap<Method, Invoker> map2 = new IdentityHashMap<Method, Invoker>(this.fastLookupTable);
        invoker = this.invokerMap.get(method);
        map2.put(method, invoker);
        if (invoker == null) {
            throw new UnsatisfiedLinkError("no invoker for native method " + method.getName());
        }
        this.fastLookupTable = map2;
        return invoker;
    }
}

