/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import org.jruby.RubyString;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.jffi.NativeStringHandle;
import org.jruby.ext.ffi.jffi.PointerParameterStrategy;
import org.jruby.ext.ffi.jffi.TransientNativeMemoryIO;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

public class ConstStringPointerParameterStrategy
extends PointerParameterStrategy {
    public ConstStringPointerParameterStrategy() {
        super(DIRECT);
    }

    @Override
    public long address(Object parameter) {
        RubyString s2 = (RubyString)parameter;
        Object existingHandle = s2.getFFIHandle();
        if (existingHandle instanceof NativeStringHandle) {
            NativeStringHandle sh = (NativeStringHandle)existingHandle;
            if (s2.getByteList() == sh.bl) {
                return sh.memory.getAddress();
            }
        }
        ByteList bl = s2.getByteList();
        StringSupport.checkStringSafety(s2.getRuntime(), s2);
        DirectMemoryIO memory = TransientNativeMemoryIO.allocateAligned(s2.getRuntime(), bl.length() + 1, 1, false);
        memory.putZeroTerminatedByteArray(0L, bl.getUnsafeBytes(), bl.begin(), bl.length());
        s2.setByteListShared();
        s2.setFFIHandle(new NativeStringHandle(memory, s2.getByteList()));
        return memory.getAddress();
    }

    @Override
    public Object object(Object parameter) {
        StringSupport.checkStringSafety(((IRubyObject)parameter).getRuntime(), (IRubyObject)parameter);
        return ((RubyString)parameter).getByteList().unsafeBytes();
    }

    @Override
    public int offset(Object parameter) {
        return ((RubyString)parameter).getByteList().begin();
    }

    @Override
    public int length(Object parameter) {
        return ((RubyString)parameter).getByteList().length();
    }
}

